/*
 * Decompiled with CFR 0.152.
 */
package water.init;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import water.H2O;
import water.Iced;
import water.persist.Persist;
import water.persist.PersistManager;
import water.util.FileUtils;
import water.util.Log;

public class NodePersistentStorage {
    final String NPS_DIR;
    final String NPS_SEPARATOR;

    public NodePersistentStorage(String npsDir) {
        if (npsDir == null) {
            this.NPS_DIR = null;
            this.NPS_SEPARATOR = null;
            return;
        }
        this.NPS_SEPARATOR = PersistManager.isHdfsPath(npsDir) ? "/" : File.separator;
        String s = npsDir.toString();
        if (s.startsWith("file://")) {
            s = s.substring(7);
        } else if (s.startsWith("file:")) {
            s = s.substring(5);
        }
        this.NPS_DIR = s;
    }

    private void validateGeneral() {
        if (this.NPS_DIR == null) {
            throw new IllegalArgumentException("NodePersistentStorage directory not specified (try setting -flow_dir)");
        }
    }

    private void validateCategoryName(String categoryName) {
        if (categoryName == null) {
            throw new IllegalArgumentException("NodePersistentStorage category not specified");
        }
        if (!Pattern.matches("[\\-a-zA-Z0-9]+", categoryName)) {
            throw new IllegalArgumentException("NodePersistentStorage illegal category (" + categoryName + ")");
        }
    }

    private void validateKeyName(String keyName) {
        if (keyName == null) {
            throw new IllegalArgumentException("NodePersistentStorage name not specified");
        }
        if (!Pattern.matches("[\\-a-zA-Z0-9_ \\(\\)]+", keyName)) {
            throw new IllegalArgumentException("NodePersistentStorage illegal name (" + keyName + ")");
        }
    }

    public boolean configured() {
        return this.NPS_DIR != null;
    }

    public boolean exists(String categoryName) {
        this.validateGeneral();
        this.validateCategoryName(categoryName);
        String dirName = this.NPS_DIR + this.NPS_SEPARATOR + categoryName;
        return H2O.getPM().exists(dirName);
    }

    public boolean exists(String categoryName, String keyName) {
        this.validateGeneral();
        this.validateCategoryName(categoryName);
        this.validateKeyName(keyName);
        String fileName = this.NPS_DIR + this.NPS_SEPARATOR + categoryName + this.NPS_SEPARATOR + keyName;
        return H2O.getPM().exists(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String categoryName, String keyName, InputStream is) {
        boolean success;
        boolean success2;
        boolean success3;
        boolean success4;
        Log.info("NPS put content category(" + categoryName + ") keyName(" + keyName + ")");
        this.validateGeneral();
        this.validateCategoryName(categoryName);
        this.validateKeyName(keyName);
        PersistManager pm = H2O.getPM();
        if (!pm.exists(this.NPS_DIR) && !(success4 = pm.mkdirs(this.NPS_DIR))) {
            throw new RuntimeException("Could not make NodePersistentStorage directory (" + this.NPS_DIR + ")");
        }
        if (!pm.exists(this.NPS_DIR)) {
            throw new RuntimeException("NodePersistentStorage directory does not exist (" + this.NPS_DIR + ")");
        }
        String tmpd = this.NPS_DIR + this.NPS_SEPARATOR + "_tmp";
        if (!pm.exists(tmpd) && !(success3 = pm.mkdirs(tmpd))) {
            throw new RuntimeException("Could not make NodePersistentStorage category directory (" + tmpd + ")");
        }
        if (!pm.exists(tmpd)) {
            throw new RuntimeException("NodePersistentStorage category directory does not exist (" + tmpd + ")");
        }
        String d2 = this.NPS_DIR + this.NPS_SEPARATOR + categoryName;
        if (!pm.exists(d2) && !(success2 = pm.mkdirs(d2))) {
            throw new RuntimeException("Could not make NodePersistentStorage category directory (" + d2 + ")");
        }
        if (!pm.exists(d2)) {
            throw new RuntimeException("NodePersistentStorage category directory does not exist (" + d2 + ")");
        }
        String tmpf = tmpd + this.NPS_SEPARATOR + keyName;
        OutputStream os = null;
        try {
            os = pm.create(tmpf, true);
            FileUtils.copyStream(is, os, 1024);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {
                    Log.err(e);
                }
            }
        }
        String realf = d2 + this.NPS_SEPARATOR + keyName;
        if (pm.exists(realf) && !(success = pm.delete(realf))) {
            throw new RuntimeException("NodePersistentStorage delete failed (" + realf + ")");
        }
        success = pm.rename(tmpf, realf);
        if (!success) {
            throw new RuntimeException("NodePersistentStorage rename failed (" + tmpf + " -> " + realf + ")");
        }
        if (!pm.exists(realf)) {
            throw new RuntimeException("NodePersistentStorage file does not exist (" + realf + ")");
        }
        Log.info("Put succeeded");
    }

    public void put(String categoryName, String keyName, String value) {
        this.validateGeneral();
        this.validateCategoryName(categoryName);
        this.validateKeyName(keyName);
        ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes());
        this.put(categoryName, keyName, is);
    }

    public NodePersistentStorageEntry[] list(String categoryName) {
        this.validateGeneral();
        this.validateCategoryName(categoryName);
        String dirName = this.NPS_DIR + this.NPS_SEPARATOR + categoryName;
        Persist.PersistEntry[] arr1 = H2O.getPM().list(dirName);
        NodePersistentStorageEntry[] arr2 = new NodePersistentStorageEntry[arr1.length];
        for (int i = 0; i < arr1.length; ++i) {
            arr2[i] = new NodePersistentStorageEntry();
            arr2[i]._category = categoryName;
            arr2[i]._name = arr1[i]._name;
            arr2[i]._size = arr1[i]._size;
            arr2[i]._timestamp_millis = arr1[i]._timestamp_millis;
        }
        return arr2;
    }

    public String get_as_string(String categoryName, String keyName) {
        this.validateGeneral();
        this.validateCategoryName(categoryName);
        this.validateKeyName(keyName);
        String fileName = this.NPS_DIR + this.NPS_SEPARATOR + categoryName + this.NPS_SEPARATOR + keyName;
        InputStream is = H2O.getPM().open(fileName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        try {
            int n = is.read(buf, 0, buf.length);
            while (true) {
                if ((long)baos.size() > 0x40000000L) {
                    throw new RuntimeException("File too big (" + fileName + ")");
                }
                if (n < 0) {
                    return baos.toString();
                }
                baos.write(buf, 0, n);
                n = is.read(buf, 0, buf.length);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long get_length(String categoryName, String keyName) {
        this.validateGeneral();
        this.validateCategoryName(categoryName);
        this.validateKeyName(keyName);
        String fileName = this.NPS_DIR + this.NPS_SEPARATOR + categoryName + this.NPS_SEPARATOR + keyName;
        if (!H2O.getPM().exists(fileName)) {
            throw new IllegalArgumentException("File not found (" + fileName + ")");
        }
        return H2O.getPM().length(fileName);
    }

    public InputStream get(String categoryName, String keyName, AtomicLong length) {
        this.validateGeneral();
        this.validateCategoryName(categoryName);
        this.validateKeyName(keyName);
        String fileName = this.NPS_DIR + this.NPS_SEPARATOR + categoryName + this.NPS_SEPARATOR + keyName;
        if (length != null) {
            length.set(H2O.getPM().length(fileName));
        }
        return H2O.getPM().open(fileName);
    }

    public void delete(String categoryName, String keyName) {
        this.validateGeneral();
        this.validateCategoryName(categoryName);
        this.validateKeyName(keyName);
        String fileName = this.NPS_DIR + this.NPS_SEPARATOR + categoryName + this.NPS_SEPARATOR + keyName;
        if (!H2O.getPM().exists(fileName)) {
            return;
        }
        boolean success = H2O.getPM().delete(fileName);
        if (!success) {
            throw new RuntimeException("NodePersistentStorage delete failed (" + fileName + ")");
        }
    }

    public static class NodePersistentStorageEntry
    extends Iced {
        public String _category;
        public String _name;
        public long _size;
        public long _timestamp_millis;
    }
}

