/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import water.Iced;
import water.parser.BufferedString;
import water.parser.ParseDataset;
import water.parser.ParseTime;
import water.parser.ParseUUID;
import water.parser.ParseWriter;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.PrettyPrint;

public class PreviewParseWriter
extends Iced
implements ParseWriter {
    protected static final int MAX_PREVIEW_COLS = 100;
    protected static final int MAX_PREVIEW_LINES = 10;
    protected int _nlines;
    protected int _ncols;
    protected int _invalidLines;
    private String[] _colNames;
    protected String[][] _data = new String[10][];
    private IcedHashMap<String, String>[] _domains;
    int[] _nnums;
    int[] _nstrings;
    int[] _ndates;
    int[] _nUUID;
    int[] _nzeros;
    int[] _nempty;
    protected ParseWriter.ParseErr[] _errs = new ParseWriter.ParseErr[0];

    protected PreviewParseWriter() {
    }

    protected PreviewParseWriter(int ncols) {
        this.setColumnCount(ncols);
    }

    String[] colNames() {
        return this._colNames;
    }

    @Override
    public void setColumnNames(String[] names) {
        this._colNames = names;
        this._data[0] = names;
        ++this._nlines;
        this.setColumnCount(names.length);
    }

    private void setColumnCount(int n) {
        if (this._ncols == 0 && n > 0) {
            int i;
            this._ncols = n;
            this._nzeros = new int[n];
            this._nstrings = new int[n];
            this._nUUID = new int[n];
            this._ndates = new int[n];
            this._nnums = new int[n];
            this._nempty = new int[n];
            this._domains = new IcedHashMap[n];
            for (i = 0; i < n; ++i) {
                this._domains[i] = new IcedHashMap();
            }
            for (i = 0; i < 10; ++i) {
                this._data[i] = new String[n];
            }
        }
    }

    @Override
    public void newLine() {
        ++this._nlines;
    }

    @Override
    public boolean isString(int colIdx) {
        return false;
    }

    @Override
    public void addNumCol(int colIdx, long number, int exp) {
        if (colIdx < this._ncols) {
            if (number == 0L) {
                int n = colIdx;
                this._nzeros[n] = this._nzeros[n] + 1;
            } else {
                int n = colIdx;
                this._nnums[n] = this._nnums[n] + 1;
            }
            if (this._nlines < 10) {
                this._data[this._nlines][colIdx] = Double.toString((double)number * PrettyPrint.pow10(exp));
            }
        }
    }

    @Override
    public void addNumCol(int colIdx, double d) {
        if (colIdx < this._ncols) {
            if (d == 0.0) {
                int n = colIdx;
                this._nzeros[n] = this._nzeros[n] + 1;
            } else {
                int n = colIdx;
                this._nnums[n] = this._nnums[n] + 1;
            }
            if (this._nlines < 10) {
                this._data[this._nlines][colIdx] = Double.toString(d);
            }
        }
    }

    @Override
    public void addInvalidCol(int colIdx) {
        if (colIdx < this._ncols) {
            int n = colIdx;
            this._nempty[n] = this._nempty[n] + 1;
            if (this._nlines < 10) {
                this._data[this._nlines][colIdx] = "NA";
            }
        }
    }

    @Override
    public void addStrCol(int colIdx, BufferedString str) {
        if (colIdx < this._ncols) {
            if (ParseTime.isTime(str)) {
                int n = colIdx;
                this._ndates[n] = this._ndates[n] + 1;
                return;
            }
            if (ParseUUID.isUUID(str)) {
                int n = colIdx;
                this._nUUID[n] = this._nUUID[n] + 1;
                return;
            }
            int n = colIdx;
            this._nstrings[n] = this._nstrings[n] + 1;
            this._domains[colIdx].put(str.toString(), "");
            if (this._nlines < 10) {
                this._data[this._nlines][colIdx] = str.toString();
            }
        }
    }

    @Override
    public void rollbackLine() {
        --this._nlines;
    }

    @Override
    public void setIsAllASCII(int colIdx, boolean b) {
    }

    public byte[] guessTypes() {
        byte[] types = new byte[this._ncols];
        for (int i = 0; i < this._ncols; ++i) {
            int nonemptyLines = this._nlines - this._nempty[i] - 1;
            types[i] = this._nnums[i] + this._nzeros[i] >= this._ndates[i] && this._nnums[i] + this._nzeros[i] >= this._nUUID[i] && this._nnums[i] >= this._nstrings[i] ? 3 : (this._domains[i].size() == 1 && !this._domains[i].containsKey("NA") && !this._domains[i].containsKey("na") && !this._domains[i].containsKey("Na") && this._nstrings[i] >= nonemptyLines ? 4 : (this._domains[i].size() == 1 && (this._domains[i].containsKey("NA") || !this._domains[i].containsKey("na") || !this._domains[i].containsKey("Na") || this._nstrings[i] >= nonemptyLines) ? 3 : (this._domains[i].size() <= 1 && this._nnums[i] + this._nzeros[i] > this._ndates[i] + this._nUUID[i] ? 3 : (this._ndates[i] > this._nUUID[i] && this._ndates[i] > this._nnums[i] + this._nzeros[i] && (this._ndates[i] > this._nstrings[i] || this._domains[i].size() <= 1) ? 5 : (this._nUUID[i] > this._ndates[i] && this._nUUID[i] > this._nnums[i] + this._nzeros[i] && (this._nUUID[i] > this._nstrings[i] || this._domains[i].size() <= 1) ? 1 : (this._nstrings[i] > this._ndates[i] && this._nstrings[i] > this._nUUID[i] && this._nstrings[i] > this._nnums[i] + this._nzeros[i] && (double)this._domains[i].size() >= 0.95 * (double)this._nstrings[i] ? 2 : (this._nzeros[i] > 0 && this._nzeros[i] + this._nstrings[i] >= nonemptyLines && (double)this._domains[i].size() <= 0.95 * (double)this._nstrings[i] ? 4 : (this._nstrings[i] >= this._nnums[i] + this._nzeros[i] && (double)this._domains[i].size() <= 0.95 * (double)this._nstrings[i] ? 4 : 3))))))));
        }
        return types;
    }

    public String[][] guessNAStrings(byte[] types) {
        String[][] naStrings = new String[this._ncols][];
        boolean empty = true;
        for (int i = 0; i < this._ncols; ++i) {
            int nonemptyLines = this._nlines - this._nempty[i] - 1;
            if (types[i] != 4 || this._nzeros[i] <= 0 || this._nzeros[i] + this._nstrings[i] < nonemptyLines || !((double)this._domains[i].size() <= 0.95 * (double)this._nstrings[i])) continue;
            naStrings[i] = new String[1];
            naStrings[i][0] = "0";
            empty = false;
        }
        if (empty) {
            return null;
        }
        return naStrings;
    }

    public static PreviewParseWriter unifyColumnPreviews(PreviewParseWriter prevA, PreviewParseWriter prevB) {
        if (prevA == null) {
            return prevB;
        }
        if (prevB == null) {
            return prevA;
        }
        if (prevA._ncols != prevB._ncols) {
            throw new ParseDataset.H2OParseException("Files conflict in number of columns. " + prevA._ncols + " vs. " + prevB._ncols + ".");
        }
        prevA._nlines += prevB._nlines;
        prevA._invalidLines += prevB._invalidLines;
        for (int i = 0; i < prevA._ncols; ++i) {
            int n = i;
            prevA._nnums[n] = prevA._nnums[n] + prevB._nnums[i];
            int n2 = i;
            prevA._nstrings[n2] = prevA._nstrings[n2] + prevB._nstrings[i];
            int n3 = i;
            prevA._ndates[n3] = prevA._ndates[n3] + prevB._ndates[i];
            int n4 = i;
            prevA._nUUID[n4] = prevA._nUUID[n4] + prevB._nUUID[i];
            int n5 = i;
            prevA._nzeros[n5] = prevA._nzeros[n5] + prevB._nzeros[i];
            int n6 = i;
            prevA._nempty[n6] = prevA._nempty[n6] + prevB._nempty[i];
            if (prevA._domains[i] != null) {
                if (prevB._domains[i] == null) continue;
                for (String s : prevB._domains[i].keySet()) {
                    prevA._domains[i].put(s, "");
                }
                continue;
            }
            if (prevB._domains[i] == null) continue;
            prevA._domains = prevB._domains;
        }
        return prevA;
    }

    @Override
    public void invalidLine(ParseWriter.ParseErr err) {
        this.addError(err);
        ++this._invalidLines;
    }

    @Override
    public void addError(ParseWriter.ParseErr err) {
        if (this._errs == null) {
            this._errs = new ParseWriter.ParseErr[]{err};
        } else if (this._errs.length < 20) {
            this._errs = ArrayUtils.append(this._errs, err);
        }
    }

    @Override
    public boolean hasErrors() {
        return this._errs != null && this._errs.length > 0;
    }

    @Override
    public ParseWriter.ParseErr[] removeErrors() {
        return this._errs;
    }

    @Override
    public long lineNum() {
        return this._nlines;
    }
}

