/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import water.rapids.AST;
import water.rapids.ASTFun;
import water.rapids.ASTId;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.Val;
import water.rapids.ValFun;
import water.util.SB;

public class ASTExec
extends AST {
    public final AST[] _asts;

    ASTExec(AST[] asts) {
        this._asts = asts;
    }

    protected ASTExec(Exec e) {
        e.xpeek('(');
        AST ast = e.parse();
        if (!(ast instanceof ASTExec || ast instanceof ASTId || ast instanceof ASTFun)) {
            e.throwErr("Expected a function but found a " + ast.getClass());
        }
        ArrayList<AST> asts = new ArrayList<AST>();
        asts.add(0, ast);
        while (e.skipWS() != ')') {
            asts.add(e.parse());
        }
        e.xpeek(')');
        this._asts = asts.toArray(new AST[asts.size()]);
    }

    @Override
    public String str() {
        SB sb = new SB().p('(');
        for (AST ast : this._asts) {
            sb.p(ast.toString()).p(' ');
        }
        return sb.p(')').toString();
    }

    @Override
    public Val exec(Env env) {
        Val fun = this._asts[0].exec(env);
        if (!fun.isFun()) {
            throw new IllegalArgumentException("Expected a function but found " + fun.getClass());
        }
        AST ast = ((ValFun)fun)._ast;
        int nargs = ast.nargs();
        if (nargs != -1 && nargs != this._asts.length) {
            throw new IllegalArgumentException("Incorrect number of arguments; '" + ast + "' expects " + nargs + " but was passed " + this._asts.length);
        }
        Env.StackHelp stk = env.stk();
        Throwable throwable = null;
        try {
            Val val = env.returning(ast.apply(env, stk, this._asts));
            return val;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (stk != null) {
                if (throwable != null) {
                    try {
                        stk.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    stk.close();
                }
            }
        }
    }

    @Override
    int nargs() {
        return -1;
    }

    public String[] getArgs() {
        return ((ValFun)this._asts[0].exec(new Env(null))).getArgs();
    }
}

