/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import java.util.Iterator;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.ValNums;

class ASTFilterNACols
extends ASTPrim {
    ASTFilterNACols() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "fraction"};
    }

    @Override
    int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "filterNACols";
    }

    @Override
    public ValNums apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        double frac = asts[2].exec(env).getNum();
        double nrow = (double)fr.numRows() * frac;
        Vec[] vecs = fr.vecs();
        ArrayList<Double> idxs = new ArrayList<Double>();
        for (double i = 0.0; i < (double)fr.numCols(); i += 1.0) {
            if (!((double)vecs[(int)i].naCnt() < nrow)) continue;
            idxs.add(i);
        }
        double[] include_cols = new double[idxs.size()];
        int i = 0;
        Iterator i$ = idxs.iterator();
        while (i$.hasNext()) {
            double d = (Double)i$.next();
            include_cols[i++] = d;
        }
        return new ValNums(include_cols);
    }
}

