/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import java.util.Comparator;
import water.H2O;
import water.Iced;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTNum;
import water.rapids.ASTNumList;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.rapids.ValFun;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.Log;

public class ASTGroup
extends ASTPrim {
    @Override
    int nargs() {
        return -1;
    }

    @Override
    public String[] args() {
        return new String[]{"..."};
    }

    @Override
    public String str() {
        return "GB";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        int ncols = fr.numCols();
        ASTNumList groupby = ASTGroup.check(ncols, asts[2]);
        final int[] gbCols = groupby.expand4();
        int naggs = (asts.length - 3) / 3;
        final AGG[] aggs = new AGG[naggs];
        for (int idx = 3; idx < asts.length; idx += 3) {
            Val v = asts[idx].exec(env);
            String fn = v instanceof ValFun ? v.getFun().str() : v.getStr();
            FCN fcn = FCN.valueOf(fn);
            ASTNumList col = ASTGroup.check(ncols, asts[idx + 1]);
            if (col.cnt() != 1L) {
                throw new IllegalArgumentException("Group-By functions take only a single column");
            }
            int agg_col = (int)col.min();
            if (fcn == FCN.mode && !fr.vec(agg_col).isCategorical()) {
                throw new IllegalArgumentException("Mode only allowed on categorical columns");
            }
            NAHandling na = NAHandling.valueOf(asts[idx + 2].exec(env).getStr().toUpperCase());
            aggs[(idx - 3) / 3] = new AGG(fcn, agg_col, na, (int)fr.vec(agg_col).max() + 1);
        }
        IcedHashMap<G, String> gss = ASTGroup.doGroups(fr, gbCols, aggs);
        final G[] grps = gss.keySet().toArray(new G[gss.size()]);
        if (gbCols.length > 0) {
            Arrays.sort(grps, new Comparator<G>(){

                @Override
                public int compare(G g1, G g2) {
                    for (int i = 0; i < gbCols.length; ++i) {
                        if (Double.isNaN(g1._gs[i]) && !Double.isNaN(g2._gs[i])) {
                            return -1;
                        }
                        if (!Double.isNaN(g1._gs[i]) && Double.isNaN(g2._gs[i])) {
                            return 1;
                        }
                        if (g1._gs[i] == g2._gs[i]) continue;
                        return g1._gs[i] < g2._gs[i] ? -1 : 1;
                    }
                    return 0;
                }

                @Override
                public boolean equals(Object o) {
                    throw H2O.unimpl();
                }
            });
        }
        String[] fcnames = new String[aggs.length];
        for (int i = 0; i < aggs.length; ++i) {
            fcnames[i] = aggs[i]._fcn.toString() + "_" + fr.name(aggs[i]._col);
        }
        MRTask mrfill = new MRTask(){

            @Override
            public void map(Chunk[] c, NewChunk[] ncs) {
                int start = (int)c[0].start();
                for (int i = 0; i < c[0]._len; ++i) {
                    int j;
                    G g = grps[i + start];
                    for (j = 0; j < g._gs.length; ++j) {
                        ncs[j].addNum(g._gs[j]);
                    }
                    for (int a = 0; a < aggs.length; ++a) {
                        ncs[j++].addNum(aggs[a]._fcn.postPass(g._dss[a], g._ns[a]));
                    }
                }
            }
        };
        Frame f = ASTGroup.buildOutput(gbCols, naggs, fr, fcnames, grps.length, mrfill);
        return new ValFrame(f);
    }

    static ASTNumList check(long dstX, AST ast) {
        ASTNumList dim;
        if (ast instanceof ASTNumList) {
            dim = (ASTNumList)ast;
        } else if (ast instanceof ASTNum) {
            dim = new ASTNumList(((ASTNum)ast)._v.getNum());
        } else {
            throw new IllegalArgumentException("Requires a number-list, but found a " + ast.getClass());
        }
        if (dim.isEmpty()) {
            return dim;
        }
        for (int col : dim.expand4()) {
            if (0 <= col && (long)col < dstX) continue;
            throw new IllegalArgumentException("Selection must be an integer from 0 to " + dstX);
        }
        return dim;
    }

    static IcedHashMap<G, String> doGroups(Frame fr, int[] gbCols, AGG[] aggs) {
        long start = System.currentTimeMillis();
        GBTask p1 = (GBTask)new GBTask(gbCols, aggs).doAll(fr);
        Log.info("Group By Task done in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " (s)");
        return p1._gss;
    }

    static AGG[] aggNRows() {
        return new AGG[]{new AGG(FCN.nrow, 0, NAHandling.IGNORE, 0)};
    }

    static Frame buildOutput(int[] gbCols, int noutCols, Frame fr, String[] fcnames, int ngrps, MRTask mrfill) {
        int i;
        int nCols = gbCols.length + noutCols;
        String[] names = new String[nCols];
        String[][] domains = new String[nCols][];
        for (i = 0; i < gbCols.length; ++i) {
            names[i] = fr.name(gbCols[i]);
            domains[i] = fr.domains()[gbCols[i]];
        }
        for (i = 0; i < fcnames.length; ++i) {
            names[i + gbCols.length] = fcnames[i];
        }
        Vec v = Vec.makeZero(ngrps);
        Frame f = ((MRTask)mrfill.doAll(nCols, (byte)3, new Frame(v))).outputFrame(names, domains);
        v.remove();
        return f;
    }

    public static class G
    extends Iced {
        final double[] _gs;
        int _hash;
        public final double[][] _dss;
        public final long[] _ns;

        public G(int ncols, AGG[] aggs) {
            this._gs = new double[ncols];
            int len = aggs == null ? 0 : aggs.length;
            this._dss = new double[len][];
            this._ns = new long[len];
            for (int i = 0; i < len; ++i) {
                this._dss[i] = aggs[i].initVal();
            }
        }

        public G fill(int row, Chunk[] chks, int[] cols) {
            for (int c = 0; c < cols.length; ++c) {
                this._gs[c] = chks[cols[c]].atd(row);
            }
            this._hash = this.hash();
            return this;
        }

        protected int hash() {
            long h = 0L;
            for (double d : this._gs) {
                h += Double.doubleToRawLongBits(d);
            }
            h ^= h >>> 20 ^ h >>> 12;
            h ^= h >>> 7 ^ h >>> 4;
            return (int)((h ^ h >> 32) & Integer.MAX_VALUE);
        }

        public boolean equals(Object o) {
            return o instanceof G && Arrays.equals(this._gs, ((G)o)._gs);
        }

        public int hashCode() {
            return this._hash;
        }

        public String toString() {
            return Arrays.toString(this._gs);
        }
    }

    public static class GBTask
    extends MRTask<GBTask> {
        final IcedHashMap<G, String> _gss;
        private final int[] _gbCols;
        private final AGG[] _aggs;

        GBTask(int[] gbCols, AGG[] aggs) {
            this._gbCols = gbCols;
            this._aggs = aggs;
            this._gss = new IcedHashMap();
        }

        @Override
        public void map(Chunk[] cs) {
            IcedHashMap<G, String> gs = new IcedHashMap<G, String>();
            G gWork = new G(this._gbCols.length, this._aggs);
            for (int row = 0; row < cs[0]._len; ++row) {
                G gOld;
                gWork.fill(row, cs, this._gbCols);
                if (gs.putIfAbsent(gWork, "") == null) {
                    gOld = gWork;
                    gWork = new G(this._gbCols.length, this._aggs);
                } else {
                    gOld = gs.getk(gWork);
                }
                for (int i = 0; i < this._aggs.length; ++i) {
                    this._aggs[i].op(gOld._dss, gOld._ns, i, cs[this._aggs[i]._col].atd(row));
                }
            }
            this.reduce(gs);
        }

        @Override
        public void reduce(GBTask t) {
            if (this._gss != t._gss) {
                this.reduce(t._gss);
            }
        }

        @Override
        private void reduce(IcedHashMap<G, String> r) {
            for (G rg : r.keySet()) {
                if (this._gss.putIfAbsent(rg, "") == null) continue;
                G lg = this._gss.getk(rg);
                for (int i = 0; i < this._aggs.length; ++i) {
                    this._aggs[i].atomic_op(lg._dss, lg._ns, i, rg._dss[i], rg._ns[i]);
                }
            }
        }
    }

    public static class AGG
    extends Iced {
        final FCN _fcn;
        public final int _col;
        final NAHandling _na;
        final int _maxx;

        public AGG(FCN fcn, int col, NAHandling na, int maxx) {
            this._fcn = fcn;
            this._col = col;
            this._na = na;
            this._maxx = maxx;
        }

        public void op(double[][] d0ss, long[] n0s, int i, double d1) {
            if (!Double.isNaN(d1) || this._na == NAHandling.ALL) {
                this._fcn.op(d0ss[i], d1);
            }
            if (!Double.isNaN(d1) || this._na == NAHandling.IGNORE) {
                int n = i;
                n0s[n] = n0s[n] + 1L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void atomic_op(double[][] d0ss, long[] n0s, int i, double[] d1s, long n1) {
            double[] dArray = d0ss[i];
            synchronized (dArray) {
                this._fcn.atomic_op(d0ss[i], d1s);
                int n = i;
                n0s[n] = n0s[n] + n1;
            }
        }

        public double[] initVal() {
            return this._fcn.initVal(this._maxx);
        }
    }

    public static enum FCN {
        nrow{

            @Override
            public void op(double[] d0s, double d1) {
                d0s[0] = d0s[0] + 1.0;
            }

            @Override
            public void atomic_op(double[] d0s, double[] d1s) {
                d0s[0] = d0s[0] + d1s[0];
            }

            @Override
            public double postPass(double[] ds, long n) {
                return ds[0];
            }
        }
        ,
        mean{

            @Override
            public void op(double[] d0s, double d1) {
                d0s[0] = d0s[0] + d1;
            }

            @Override
            public void atomic_op(double[] d0s, double[] d1s) {
                d0s[0] = d0s[0] + d1s[0];
            }

            @Override
            public double postPass(double[] ds, long n) {
                return ds[0] / (double)n;
            }
        }
        ,
        sum{

            @Override
            public void op(double[] d0s, double d1) {
                d0s[0] = d0s[0] + d1;
            }

            @Override
            public void atomic_op(double[] d0s, double[] d1s) {
                d0s[0] = d0s[0] + d1s[0];
            }

            @Override
            public double postPass(double[] ds, long n) {
                return ds[0];
            }
        }
        ,
        sumSquares{

            @Override
            public void op(double[] d0s, double d1) {
                d0s[0] = d0s[0] + d1 * d1;
            }

            @Override
            public void atomic_op(double[] d0s, double[] d1s) {
                d0s[0] = d0s[0] + d1s[0];
            }

            @Override
            public double postPass(double[] ds, long n) {
                return ds[0];
            }
        }
        ,
        var{

            @Override
            public void op(double[] d0s, double d1) {
                d0s[0] = d0s[0] + d1 * d1;
                d0s[1] = d0s[1] + d1;
            }

            @Override
            public void atomic_op(double[] d0s, double[] d1s) {
                ArrayUtils.add(d0s, d1s);
            }

            @Override
            public double postPass(double[] ds, long n) {
                double numerator = ds[0] - ds[1] * ds[1] / (double)n;
                if (Math.abs(numerator) < 1.0E-5) {
                    numerator = 0.0;
                }
                return numerator / (double)(n - 1L);
            }

            @Override
            public double[] initVal(int ignored) {
                return new double[2];
            }
        }
        ,
        sdev{

            @Override
            public void op(double[] d0s, double d1) {
                d0s[0] = d0s[0] + d1 * d1;
                d0s[1] = d0s[1] + d1;
            }

            @Override
            public void atomic_op(double[] d0s, double[] d1s) {
                ArrayUtils.add(d0s, d1s);
            }

            @Override
            public double postPass(double[] ds, long n) {
                double numerator = ds[0] - ds[1] * ds[1] / (double)n;
                if (Math.abs(numerator) < 1.0E-5) {
                    numerator = 0.0;
                }
                return Math.sqrt(numerator / (double)(n - 1L));
            }

            @Override
            public double[] initVal(int ignored) {
                return new double[2];
            }
        }
        ,
        min{

            @Override
            public void op(double[] d0s, double d1) {
                d0s[0] = Math.min(d0s[0], d1);
            }

            @Override
            public void atomic_op(double[] d0s, double[] d1s) {
                this.op(d0s, d1s[0]);
            }

            @Override
            public double postPass(double[] ds, long n) {
                return ds[0];
            }

            @Override
            public double[] initVal(int maxx) {
                return new double[]{Double.MAX_VALUE};
            }
        }
        ,
        max{

            @Override
            public void op(double[] d0s, double d1) {
                d0s[0] = Math.max(d0s[0], d1);
            }

            @Override
            public void atomic_op(double[] d0s, double[] d1s) {
                this.op(d0s, d1s[0]);
            }

            @Override
            public double postPass(double[] ds, long n) {
                return ds[0];
            }

            @Override
            public double[] initVal(int maxx) {
                return new double[]{-1.7976931348623157E308};
            }
        }
        ,
        mode{

            @Override
            public void op(double[] d0s, double d1) {
                int n = (int)d1;
                d0s[n] = d0s[n] + 1.0;
            }

            @Override
            public void atomic_op(double[] d0s, double[] d1s) {
                ArrayUtils.add(d0s, d1s);
            }

            @Override
            public double postPass(double[] ds, long n) {
                return ArrayUtils.maxIndex(ds);
            }

            @Override
            public double[] initVal(int maxx) {
                return new double[maxx];
            }
        };


        public abstract void op(double[] var1, double var2);

        public abstract void atomic_op(double[] var1, double[] var2);

        public abstract double postPass(double[] var1, long var2);

        public double[] initVal(int maxx) {
            return new double[]{0.0};
        }
    }

    public static enum NAHandling {
        ALL,
        RM,
        IGNORE;

    }
}

