/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.fvec.Frame;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.ValNums;

class ASTIsNumeric
extends ASTPrim {
    ASTIsNumeric() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "is.numeric";
    }

    @Override
    public ValNums apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (fr.numCols() == 1) {
            return new ValNums(new double[]{fr.anyVec().isNumeric() ? 1.0 : 0.0});
        }
        double[] ds = new double[fr.numCols()];
        for (int i = 0; i < fr.numCols(); ++i) {
            ds[i] = fr.vec(i).isNumeric() ? 1.0 : 0.0;
        }
        return new ValNums(ds);
    }
}

