/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.AST;
import water.rapids.ASTNum;
import water.rapids.ASTNumList;
import water.rapids.ASTPrim;
import water.rapids.ASTStr;
import water.rapids.ASTStrList;
import water.rapids.Env;
import water.rapids.ValFrame;
import water.util.MathUtils;

class ASTMatch
extends ASTPrim {
    ASTMatch() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "table", "nomatch", "incomparables"};
    }

    @Override
    int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return "match";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (fr.numCols() != 1 || !fr.anyVec().isCategorical()) {
            throw new IllegalArgumentException("can only match on a single categorical column.");
        }
        Object[] strsTable2 = null;
        double[] dblsTable2 = null;
        if (asts[2] instanceof ASTNumList) {
            dblsTable2 = ((ASTNumList)asts[2]).sort().expand();
        } else if (asts[2] instanceof ASTNum) {
            dblsTable2 = new double[]{asts[2].exec(env).getNum()};
        } else if (asts[2] instanceof ASTStrList) {
            strsTable2 = ((ASTStrList)asts[2])._strs;
            Arrays.sort(strsTable2);
        } else if (asts[2] instanceof ASTStr) {
            strsTable2 = new String[]{asts[2].exec(env).getStr()};
        } else {
            throw new IllegalArgumentException("Expected numbers/strings. Got: " + asts[2].getClass());
        }
        final double nomatch = asts[3].exec(env).getNum();
        Object[] strsTable = strsTable2;
        double[] dblsTable = dblsTable2;
        Frame rez = ((MRTask)new MRTask((String[])strsTable, dblsTable){
            final /* synthetic */ String[] val$strsTable;
            final /* synthetic */ double[] val$dblsTable;
            {
                this.val$strsTable = stringArray;
                this.val$dblsTable = dArray;
            }

            @Override
            public void map(Chunk c, NewChunk n) {
                String[] domain = c.vec().domain();
                int rows = c._len;
                for (int r = 0; r < rows; ++r) {
                    double x = c.isNA(r) ? nomatch : (this.val$strsTable == null ? ASTMatch.in(this.val$dblsTable, c.atd(r), nomatch) : ASTMatch.in(this.val$strsTable, domain[(int)c.at8(r)], nomatch));
                    n.addNum(x);
                }
            }
        }.doAll(new byte[]{3}, fr.anyVec())).outputFrame();
        return new ValFrame(rez);
    }

    private static double in(String[] matches, String s, double nomatch) {
        return Arrays.binarySearch(matches, s) >= 0 ? 1.0 : nomatch;
    }

    private static double in(double[] matches, double d, double nomatch) {
        return ASTMatch.binarySearchDoublesUlp(matches, 0, matches.length, d) >= 0 ? 1.0 : nomatch;
    }

    private static int binarySearchDoublesUlp(double[] a, int from, int to, double key) {
        int lo = from;
        int hi = to - 1;
        while (lo <= hi) {
            long keyBits;
            int mid = lo + hi >>> 1;
            double midVal = a[mid];
            if (MathUtils.equalsWithinOneSmallUlp(midVal, key)) {
                return mid;
            }
            if (midVal < key) {
                lo = mid + 1;
                continue;
            }
            if (midVal > key) {
                hi = mid - 1;
                continue;
            }
            long midBits = Double.doubleToLongBits(midVal);
            if (midBits == (keyBits = Double.doubleToLongBits(key))) {
                return mid;
            }
            if (midBits < keyBits) {
                lo = mid + 1;
                continue;
            }
            hi = mid - 1;
        }
        return -(lo + 1);
    }
}

