/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import water.DKV;
import water.Key;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.ValNum;

class ASTMedian
extends ASTPrim {
    ASTMedian() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "method"};
    }

    @Override
    public String str() {
        return "median";
    }

    @Override
    int nargs() {
        return 3;
    }

    @Override
    public ValNum apply(Env env, Env.StackHelp stk, AST[] asts) {
        boolean narm;
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        boolean bl = narm = asts[2].exec(env).getNum() == 1.0;
        if (!(narm || fr.anyVec().length() != 0L && fr.anyVec().naCnt() <= 0L)) {
            return new ValNum(Double.NaN);
        }
        return new ValNum(ASTMedian.median(fr, QuantileModel.CombineMethod.INTERPOLATE));
    }

    static double median(Frame fr, QuantileModel.CombineMethod combine_method) {
        if (fr.numCols() != 1 || !fr.anyVec().isNumeric()) {
            throw new IllegalArgumentException("median only works on a single numeric column");
        }
        Key tk = null;
        if (fr._key == null) {
            tk = Key.make();
            fr = new Frame(tk, fr.names(), fr.vecs());
            DKV.put(tk, fr);
        }
        QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
        parms._probs = new double[]{0.5};
        parms._train = fr._key;
        parms._combine_method = combine_method;
        QuantileModel q = (QuantileModel)new Quantile(parms).trainModel().get();
        double median = ((QuantileModel.QuantileOutput)q._output)._quantiles[0][0];
        q.delete();
        if (tk != null) {
            DKV.remove(tk);
        }
        return median;
    }

    static double median(Vec v, QuantileModel.CombineMethod combine_method) {
        return ASTMedian.median(new Frame(v), combine_method);
    }
}

