/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.ValNum;
import water.util.ArrayUtils;
import water.util.MRUtils;

class ASTMode
extends ASTPrim {
    ASTMode() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public String str() {
        return "mode";
    }

    @Override
    int nargs() {
        return 2;
    }

    @Override
    public ValNum apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (fr.numCols() != 1 || !fr.anyVec().isCategorical()) {
            throw new IllegalArgumentException("mean only works on a single categorical column");
        }
        return new ValNum(ASTMode.mode(fr.anyVec()));
    }

    static int mode(Vec v) {
        if (v.isNumeric()) {
            MRUtils.Dist t = (MRUtils.Dist)new MRUtils.Dist().doAll(v);
            int mode = ArrayUtils.maxIndex(t.dist());
            return (int)t.keys()[mode];
        }
        double[] dist = ((MRUtils.ClassDist)new MRUtils.ClassDist(v).doAll(v)).dist();
        return ArrayUtils.maxIndex(dist);
    }
}

