/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.ValNum;

class ASTNLevels
extends ASTPrim {
    ASTNLevels() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "nlevels";
    }

    @Override
    public ValNum apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (fr.numCols() == 1) {
            Vec v = fr.anyVec();
            int nlevels = v.isCategorical() ? v.domain().length : 0;
            return new ValNum(nlevels);
        }
        throw new IllegalArgumentException("nlevels applies to a single column. Got: " + fr.numCols());
    }
}

