/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import hex.Model;
import water.DKV;
import water.Key;
import water.fvec.Frame;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.ValNum;

class ASTRename
extends ASTPrim {
    ASTRename() {
    }

    @Override
    public String[] args() {
        return new String[]{"oldId", "newId"};
    }

    @Override
    int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "rename";
    }

    @Override
    public ValNum apply(Env env, Env.StackHelp stk, AST[] asts) {
        Key oldKey = Key.make(asts[1].exec(env).getStr());
        Key newKey = Key.make(asts[2].exec(env).getStr());
        Object o = DKV.remove(oldKey).get();
        if (o instanceof Frame) {
            DKV.put(newKey, new Frame(newKey, ((Frame)o)._names, ((Frame)o).vecs()));
        } else if (o instanceof Model) {
            ((Model)o)._key = newKey;
            DKV.put(newKey, o);
        } else {
            throw new IllegalArgumentException("Trying to rename Value of type " + o.getClass());
        }
        return new ValNum(Double.NaN);
    }
}

