/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.Futures;
import water.MRTask;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.ValFrame;

class ASTWhich
extends ASTPrim {
    ASTWhich() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "which";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame f = stk.track(asts[1].exec(env)).getFrame();
        if (f.numRows() == 1L && f.numCols() > 1) {
            AppendableVec v = new AppendableVec(Vec.VectorGroup.VG_LEN1.addVec(), 3);
            NewChunk chunk = new NewChunk(v, 0);
            for (int i = 0; i < f.numCols(); ++i) {
                if (f.vecs()[i].at8(0L) == 0L) continue;
                chunk.addNum(i);
            }
            Futures fs = chunk.close(0, new Futures());
            Vec vec = v.layout_and_close(fs);
            fs.blockForPending();
            return new ValFrame(new Frame(vec));
        }
        Vec vec = f.anyVec();
        if (f.numCols() > 1 || !vec.isInt()) {
            throw new IllegalArgumentException("which requires a single integer column");
        }
        Frame f2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c, NewChunk nc) {
                long start = c.start();
                for (int i = 0; i < c._len; ++i) {
                    if (c.at8(i) == 0L) continue;
                    nc.addNum(start + (long)i);
                }
            }
        }.doAll(new byte[]{3}, vec)).outputFrame();
        return new ValFrame(f2);
    }
}

