/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.fvec.Frame;
import water.rapids.Val;

class ValFrame
extends Val {
    final Frame _fr;

    ValFrame(Frame fr) {
        assert (fr != null);
        this._fr = fr;
    }

    public String toString() {
        return this._fr.toString();
    }

    @Override
    public int type() {
        return 5;
    }

    @Override
    public double[] getRow() {
        if (this._fr.numRows() != 1L) {
            throw new IllegalArgumentException("Trying to get a single row from a multirow frame: " + this._fr.numRows() + "!=1");
        }
        double[] res = new double[this._fr.numCols()];
        for (int i = 0; i < this._fr.numCols(); ++i) {
            res[i] = this._fr.vec(i).at(0L);
        }
        return res;
    }

    @Override
    boolean isFrame() {
        return true;
    }

    @Override
    public Frame getFrame() {
        return this._fr;
    }
}

