/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.regex.Pattern;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.Value;
import water.Weaver;
import water.api.FrameV3;
import water.api.KeyV3;
import water.api.Schema;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2ONotFoundArgumentException;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.ReflectionUtils;

public class PojoUtils {
    public static void copyProperties(Object dest, Object origin, FieldNaming field_naming) {
        PojoUtils.copyProperties(dest, origin, field_naming, null);
    }

    public static void copyProperties(Object dest, Object origin, FieldNaming field_naming, String[] skip_fields) {
        PojoUtils.copyProperties(dest, origin, field_naming, skip_fields, null);
    }

    public static void copyProperties(Object dest, Object origin, FieldNaming field_naming, String[] skip_fields, String[] only_fields) {
        Field[] orig_fields;
        if (null == dest || null == origin) {
            return;
        }
        Field[] dest_fields = Weaver.getWovenFields(dest.getClass());
        for (Field orig_field : orig_fields = Weaver.getWovenFields(origin.getClass())) {
            String origin_name = orig_field.getName();
            String dest_name = field_naming.toDest(origin_name);
            if (skip_fields != null && (ArrayUtils.contains(skip_fields, origin_name) || ArrayUtils.contains(skip_fields, dest_name)) || only_fields != null && !ArrayUtils.contains(only_fields, origin_name) && !ArrayUtils.contains(only_fields, dest_name)) continue;
            try {
                Schema s;
                KeyV3 k;
                Field dest_field = null;
                for (Field fd : dest_fields) {
                    if (!fd.getName().equals(dest_name)) continue;
                    dest_field = fd;
                    break;
                }
                if (dest_field == null) continue;
                dest_field.setAccessible(true);
                orig_field.setAccessible(true);
                if (null == orig_field.get(origin)) {
                    dest_field.set(dest, null);
                    continue;
                }
                if (dest_field.getType().isArray() && orig_field.getType().isArray() && dest_field.getType().getComponentType() != orig_field.getType().getComponentType()) {
                    Iced[] translation;
                    Iced[] orig_array_copy;
                    int length;
                    Class<?> dest_component_class;
                    Object[] copy;
                    if (dest_field.getType().getComponentType() == Double.TYPE && orig_field.getType().getComponentType() == Double.class) {
                        copy = (double[])orig_field.get(origin);
                        dest_field.set(dest, copy);
                        continue;
                    }
                    if (dest_field.getType().getComponentType() == Double.class && orig_field.getType().getComponentType() == Double.TYPE) {
                        copy = (Double[])orig_field.get(origin);
                        dest_field.set(dest, copy);
                        continue;
                    }
                    if (dest_field.getType().getComponentType() == Integer.TYPE && orig_field.getType().getComponentType() == Integer.class) {
                        copy = (int[])orig_field.get(origin);
                        dest_field.set(dest, copy);
                        continue;
                    }
                    if (dest_field.getType().getComponentType() == Integer.class && orig_field.getType().getComponentType() == Integer.TYPE) {
                        copy = (Integer[])orig_field.get(origin);
                        dest_field.set(dest, copy);
                        continue;
                    }
                    if (Schema.class.isAssignableFrom(dest_field.getType().getComponentType()) && Schema.getImplClass(dest_field.getType().getComponentType()).isAssignableFrom(orig_field.getType().getComponentType())) {
                        dest_component_class = dest_field.getType().getComponentType();
                        Iced[] orig_array = (Iced[])orig_field.get(origin);
                        length = orig_array.length;
                        orig_array_copy = Arrays.copyOf(orig_array, length);
                        translation = (Schema[])Array.newInstance(dest_component_class, length);
                        int version = ((Schema)dest).getSchemaVersion();
                        for (int i = 0; i < length; ++i) {
                            Iced impl = orig_array_copy[i];
                            if (null == impl) {
                                translation[i++] = null;
                                continue;
                            }
                            Schema s2 = null;
                            try {
                                s2 = Schema.schema(version, impl);
                            }
                            catch (H2ONotFoundArgumentException e) {
                                s2 = (Schema)dest_field.getType().getComponentType().newInstance();
                            }
                            translation[i] = s2.fillFromImpl(impl);
                        }
                        dest_field.set(dest, translation);
                        continue;
                    }
                    if (Schema.class.isAssignableFrom(orig_field.getType().getComponentType()) && Iced.class.isAssignableFrom(dest_field.getType().getComponentType())) {
                        dest_component_class = dest_field.getType().getComponentType();
                        Schema[] orig_array = (Schema[])orig_field.get(origin);
                        length = orig_array.length;
                        orig_array_copy = Arrays.copyOf(orig_array, length);
                        translation = (Iced[])Array.newInstance(dest_component_class, length);
                        for (int i = 0; i < length; ++i) {
                            Iced s3 = orig_array_copy[i];
                            translation[i] = s3 == null ? null : ((Schema)s3).createImpl();
                        }
                        dest_field.set(dest, translation);
                        continue;
                    }
                    throw H2O.fail("Don't know how to cast an array of: " + orig_field.getType().getComponentType() + " to an array of: " + dest_field.getType().getComponentType());
                }
                if (dest_field.getType() == Key.class && Keyed.class.isAssignableFrom(orig_field.getType())) {
                    dest_field.set(dest, ((Keyed)orig_field.get((Object)origin))._key);
                    continue;
                }
                if (orig_field.getType() == Key.class && Keyed.class.isAssignableFrom(dest_field.getType())) {
                    Value v = DKV.get((Key)orig_field.get(origin));
                    dest_field.set(dest, null == v ? null : v.get());
                    continue;
                }
                if (KeyV3.class.isAssignableFrom(dest_field.getType()) && Keyed.class.isAssignableFrom(orig_field.getType())) {
                    dest_field.set(dest, KeyV3.make(dest_field.getType(), ((Keyed)orig_field.get((Object)origin))._key));
                    continue;
                }
                if (KeyV3.class.isAssignableFrom(orig_field.getType()) && Keyed.class.isAssignableFrom(dest_field.getType())) {
                    k = (KeyV3)orig_field.get(origin);
                    Value v = DKV.get(Key.make(k.name));
                    dest_field.set(dest, null == v ? null : v.get());
                    continue;
                }
                if (KeyV3.class.isAssignableFrom(dest_field.getType()) && Key.class.isAssignableFrom(orig_field.getType())) {
                    dest_field.set(dest, KeyV3.make(dest_field.getType(), (Key)orig_field.get(origin)));
                    continue;
                }
                if (KeyV3.class.isAssignableFrom(orig_field.getType()) && Key.class.isAssignableFrom(dest_field.getType())) {
                    k = (KeyV3)orig_field.get(origin);
                    dest_field.set(dest, null == k.name ? null : Key.make(k.name));
                    continue;
                }
                if (dest_field.getType() == Pattern.class && String.class.isAssignableFrom(orig_field.getType())) {
                    dest_field.set(dest, Pattern.compile((String)orig_field.get(origin)));
                    continue;
                }
                if (orig_field.getType() == Pattern.class && String.class.isAssignableFrom(dest_field.getType())) {
                    dest_field.set(dest, orig_field.get(origin).toString());
                    continue;
                }
                if (dest_field.getType() == FrameV3.ColSpecifierV3.class && String.class.isAssignableFrom(orig_field.getType())) {
                    dest_field.set(dest, new FrameV3.ColSpecifierV3((String)orig_field.get(origin)));
                    continue;
                }
                if (orig_field.getType() == FrameV3.ColSpecifierV3.class && String.class.isAssignableFrom(dest_field.getType())) {
                    dest_field.set(dest, ((FrameV3.ColSpecifierV3)orig_field.get((Object)origin)).column_name);
                    continue;
                }
                if (Enum.class.isAssignableFrom(dest_field.getType()) && String.class.isAssignableFrom(orig_field.getType())) {
                    Class<?> dest_class = dest_field.getType();
                    dest_field.set(dest, Enum.valueOf(dest_class, (String)orig_field.get(origin)));
                    continue;
                }
                if (Enum.class.isAssignableFrom(orig_field.getType()) && String.class.isAssignableFrom(dest_field.getType())) {
                    Object o = orig_field.get(origin);
                    dest_field.set(dest, o == null ? null : o.toString());
                    continue;
                }
                if (Schema.class.isAssignableFrom(dest_field.getType()) && Schema.getImplClass(dest_field.getType()).isAssignableFrom(orig_field.getType())) {
                    dest_field.set(dest, Schema.schema(3, orig_field.get(origin).getClass()).fillFromImpl((Iced)orig_field.get(origin)));
                    continue;
                }
                if (Schema.class.isAssignableFrom(orig_field.getType()) && Schema.getImplClass(orig_field.getType()).isAssignableFrom(dest_field.getType())) {
                    s = (Schema)orig_field.get(origin);
                    dest_field.set(dest, s.fillImpl(s.createImpl()));
                    continue;
                }
                if (Schema.class.isAssignableFrom(dest_field.getType()) && Key.class.isAssignableFrom(orig_field.getType())) {
                    Key origin_key = (Key)orig_field.get(origin);
                    Value v = DKV.get(origin_key);
                    if (null == v || null == v.get()) {
                        dest_field.set(dest, null);
                        continue;
                    }
                    if (((Schema)dest_field.get(dest)).getImplClass().isAssignableFrom(v.get().getClass())) {
                        Schema s4 = (Schema)dest_field.get(dest);
                        dest_field.set(dest, Schema.schema(s4.getSchemaVersion(), s4.getImplClass()).fillFromImpl(v.get()));
                        continue;
                    }
                    Log.err("Can't fill Schema of type: " + dest_field.getType() + " with value of type: " + v.getClass() + " fetched from Key: " + origin_key);
                    dest_field.set(dest, null);
                    continue;
                }
                if (Schema.class.isAssignableFrom(orig_field.getType()) && Keyed.class.isAssignableFrom(dest_field.getType())) {
                    s = (Schema)orig_field.get(origin);
                    dest_field.set(dest, ((Keyed)s.fillImpl(s.createImpl()))._key);
                    continue;
                }
                dest_field.set(dest, orig_field.get(origin));
            }
            catch (IllegalAccessException e) {
                Log.err("Illegal access exception trying to copy field: " + origin_name + " of class: " + origin.getClass() + " to field: " + dest_name + " of class: " + dest.getClass());
            }
            catch (InstantiationException e) {
                Log.err("Instantiation exception trying to copy field: " + origin_name + " of class: " + origin.getClass() + " to field: " + dest_name + " of class: " + dest.getClass());
            }
            catch (Exception e) {
                Log.err(e.getClass().getCanonicalName() + " Exception: " + origin_name + " of class: " + origin.getClass() + " to field: " + dest_name + " of class: " + dest.getClass());
                throw e;
            }
        }
    }

    public static void filterFields(Object o, String includes, String excludes) {
        String[] exclude_paths;
        if (null == excludes || "".equals(excludes)) {
            return;
        }
        if (null != includes) {
            throw new H2OIllegalArgumentException("_include_fields", "filterFields", includes);
        }
        for (String path : exclude_paths = excludes.split(",")) {
            Object[] field_value;
            int slash = path.indexOf("/");
            if (-1 == slash || slash == path.length()) {
                Field f = ReflectionUtils.findNamedField(o, path);
                if (null == f) {
                    throw new H2OIllegalArgumentException("_exclude_fields", "filterFields", path);
                }
                try {
                    f.set(o, null);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new H2OIllegalArgumentException("_exclude_fields", "filterFields", path);
                }
            }
            String first = path.substring(0, slash);
            String rest = path.substring(slash + 1);
            Field f = ReflectionUtils.findNamedField(o, first);
            if (null == f) {
                throw new H2OIllegalArgumentException("_exclude_fields", "filterFields", path);
            }
            if (f.getType().isArray() && Object.class.isAssignableFrom(f.getType().getComponentType())) {
                try {
                    for (Object child : field_value = (Object[])f.get(o)) {
                        PojoUtils.filterFields(child, null, rest);
                    }
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new H2OIllegalArgumentException("_exclude_fields", "filterFields", path);
                }
            }
            if (Object.class.isAssignableFrom(f.getType())) {
                try {
                    field_value = f.get(o);
                    PojoUtils.filterFields(field_value, null, rest);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new H2OIllegalArgumentException("_exclude_fields", "filterFields", path);
                }
            }
            throw new H2OIllegalArgumentException("_exclude_fields", "filterFields", path);
        }
    }

    public static boolean equals(Object a, Field fa, Object b, Field fb) {
        try {
            Object va = fa.get(a);
            Object vb = fb.get(b);
            return va == null ? vb == null : va.equals(vb);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void setField(Object o, String fieldName, Object value, FieldNaming objectNamingConvention) {
        String destFieldName = null;
        switch (objectNamingConvention) {
            case CONSISTENT: {
                destFieldName = fieldName;
                break;
            }
            case DEST_HAS_UNDERSCORES: {
                if (fieldName.startsWith("_")) {
                    destFieldName = fieldName;
                    break;
                }
                destFieldName = "_" + fieldName;
                break;
            }
            case ORIGIN_HAS_UNDERSCORES: {
                if (fieldName.startsWith("_")) {
                    destFieldName = fieldName.substring(1);
                    break;
                }
                throw new IllegalArgumentException("Wrong combination of options!");
            }
        }
        PojoUtils.setField(o, destFieldName, value);
    }

    public static void setField(Object o, String fieldName, Object value) {
        try {
            Field f = o.getClass().getField(fieldName);
            f.set(o, value);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Field " + fieldName + " not found!", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Field=" + fieldName + " cannot be set to value=" + value, e);
        }
    }

    public static Object getFieldValue(Object o, String name, FieldNaming fieldNaming) {
        if (o == null) {
            throw new IllegalArgumentException("Cannot get the field from null object!");
        }
        String destName = fieldNaming.toDest(name);
        try {
            Field f = o.getClass().getField(destName);
            return f.get(o);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Field not found: '" + name + "/" + destName + "' on object " + o);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot get value of the field: '" + name + "/" + destName + "' on object " + o);
        }
    }

    public static boolean arraysEquals(Object a, Object b) {
        if (a == null || !a.getClass().isArray()) {
            throw new H2OIllegalArgumentException("a", "arraysEquals", a);
        }
        if (b == null || !b.getClass().isArray()) {
            throw new H2OIllegalArgumentException("b", "arraysEquals", b);
        }
        if (a.getClass().getComponentType() != b.getClass().getComponentType()) {
            throw new H2OIllegalArgumentException("Can't compare arrays of different types: " + a.getClass().getComponentType() + " and: " + b.getClass().getComponentType());
        }
        if (a.getClass().getComponentType() == Boolean.TYPE) {
            return Arrays.equals((boolean[])a, (boolean[])b);
        }
        if (a.getClass().getComponentType() == Boolean.class) {
            return Arrays.equals((Object[])((Boolean[])a), (Object[])((Boolean[])b));
        }
        if (a.getClass().getComponentType() == Character.TYPE) {
            return Arrays.equals((char[])a, (char[])b);
        }
        if (a.getClass().getComponentType() == Short.TYPE) {
            return Arrays.equals((short[])a, (short[])b);
        }
        if (a.getClass().getComponentType() == Short.class) {
            return Arrays.equals((Object[])((Short[])a), (Object[])((Short[])b));
        }
        if (a.getClass().getComponentType() == Integer.TYPE) {
            return Arrays.equals((int[])a, (int[])b);
        }
        if (a.getClass().getComponentType() == Integer.class) {
            return Arrays.equals((Object[])((Integer[])a), (Object[])((Integer[])b));
        }
        if (a.getClass().getComponentType() == Float.TYPE) {
            return Arrays.equals((float[])a, (float[])b);
        }
        if (a.getClass().getComponentType() == Float.class) {
            return Arrays.equals((Object[])((Float[])a), (Object[])((Float[])b));
        }
        if (a.getClass().getComponentType() == Double.TYPE) {
            return Arrays.equals((double[])a, (double[])b);
        }
        if (a.getClass().getComponentType() == Double.class) {
            return Arrays.equals((Object[])((Double[])a), (Object[])((Double[])b));
        }
        return Arrays.deepEquals((Object[])a, (Object[])b);
    }

    public static enum FieldNaming {
        CONSISTENT{

            @Override
            String toDest(String origin) {
                return origin;
            }

            @Override
            String toOrigin(String dest) {
                return dest;
            }
        }
        ,
        DEST_HAS_UNDERSCORES{

            @Override
            String toDest(String origin) {
                return "_" + origin;
            }

            @Override
            String toOrigin(String dest) {
                return dest.substring(1);
            }
        }
        ,
        ORIGIN_HAS_UNDERSCORES{

            @Override
            String toDest(String origin) {
                return origin.substring(1);
            }

            @Override
            String toOrigin(String dest) {
                return "_" + dest;
            }
        };


        abstract String toDest(String var1);

        abstract String toOrigin(String var1);
    }
}

