/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.io.PrintWriter;
import java.io.StringWriter;
import water.H2O;
import water.Job;
import water.Key;
import water.Keyed;
import water.TypeMap;
import water.api.API;
import water.api.KeyV3;
import water.api.RequestSchema;
import water.util.PojoUtils;

public class JobV3
extends RequestSchema<Job, JobV3> {
    @API(help="Job Key")
    public KeyV3.JobKeyV3 key;
    @API(help="Job description")
    public String description;
    @API(help="job status", direction=API.Direction.OUTPUT)
    public String status;
    @API(help="progress, from 0 to 1", direction=API.Direction.OUTPUT)
    public float progress;
    @API(help="current progress status description", direction=API.Direction.OUTPUT)
    public String progress_msg;
    @API(help="Start time", direction=API.Direction.OUTPUT)
    public long start_time;
    @API(help="Runtime in milliseconds", direction=API.Direction.OUTPUT)
    public long msec;
    @API(help="destination key", direction=API.Direction.INOUT)
    public KeyV3 dest;
    @API(help="exception", direction=API.Direction.OUTPUT)
    public String[] warnings;
    @API(help="exception", direction=API.Direction.OUTPUT)
    public String exception;
    @API(help="stacktrace", direction=API.Direction.OUTPUT)
    public String stacktrace;
    @API(help="ready for view", direction=API.Direction.OUTPUT)
    public boolean ready_for_view;

    @Override
    public Job createImpl() {
        throw H2O.fail();
    }

    @Override
    public JobV3 fillFromImpl(Job job) {
        if (job == null) {
            return this;
        }
        PojoUtils.copyProperties(this, job, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES);
        PojoUtils.copyProperties(this, job, PojoUtils.FieldNaming.CONSISTENT);
        this.key = new KeyV3.JobKeyV3((Key<Job>)job._key);
        this.description = job._description;
        this.warnings = job.warns();
        this.progress = job.progress();
        this.progress_msg = job.progress_msg();
        this.status = job.isRunning() ? (job.stop_requested() ? "CANCEL_PENDING" : "RUNNING") : (job.stop_requested() ? "CANCELLED" : "DONE");
        Throwable ex = job.ex();
        if (ex != null) {
            this.status = "FAILED";
        }
        String string = this.exception = ex == null ? null : ex.toString();
        if (ex != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            this.stacktrace = sw.toString();
        }
        this.msec = job.msec();
        this.ready_for_view = job.readyForView();
        Keyed dest_type = (Keyed)TypeMap.theFreezable(job._typeid);
        this.dest = job._result == null ? null : KeyV3.make(dest_type.makeSchema(), job._result);
        return this;
    }

    public static String link(Key key) {
        return "/Jobs/" + key;
    }
}

