/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.ModelBuilder;
import java.util.Map;
import water.Iced;
import water.TypeMap;
import water.api.Handler;
import water.api.MetadataV3;
import water.api.ModelBuilderHandler;
import water.api.RequestServer;
import water.api.Route;
import water.api.RouteBase;
import water.api.Schema;
import water.api.SchemaMetadata;
import water.api.SchemaMetadataBase;
import water.util.MarkdownBuilder;

public class MetadataHandler
extends Handler {
    public MetadataV3 listRoutes(int version, MetadataV3 docs) {
        MarkdownBuilder builder = new MarkdownBuilder();
        builder.comment("Preview with http://jbt.github.io/markdown-editor");
        builder.heading1("REST API Routes Table of Contents");
        builder.hline();
        builder.tableHeader("HTTP method", "URI pattern", "Input schema", "Output schema", "Summary");
        docs.routes = new RouteBase[RequestServer.numRoutes()];
        int i = 0;
        for (Route route : RequestServer.routes()) {
            docs.routes[i] = (RouteBase)Schema.schema(version, Route.class).fillFromImpl(route);
            MetadataV3 look = new MetadataV3();
            look.routes = new RouteBase[1];
            look.routes[0] = docs.routes[i];
            look.path = route._url_pattern.toString();
            look.http_method = route._http_method;
            look = this.fetchRoute(version, look);
            docs.routes[i].input_schema = look.routes[0].input_schema;
            docs.routes[i].output_schema = look.routes[0].output_schema;
            builder.tableRow(route._http_method, route._url_pattern.toString().replace("(?<", "{").replace(">.*)", "}"), Handler.getHandlerMethodInputSchema(route._handler_method).getSimpleName(), Handler.getHandlerMethodOutputSchema(route._handler_method).getSimpleName(), route._summary);
            ++i;
        }
        docs.markdown = builder.toString();
        return docs;
    }

    public MetadataV3 fetchRoute(int version, MetadataV3 docs) {
        Schema soutput;
        Schema sinput;
        Route route = null;
        if (null != docs.path && null != docs.http_method) {
            route = RequestServer.lookup(docs.http_method, docs.path);
        } else {
            int i = 0;
            for (Route r : RequestServer.routes()) {
                if (i++ != docs.num) continue;
                route = r;
                break;
            }
            docs.routes = new RouteBase[]{(RouteBase)Schema.schema(version, Route.class).fillFromImpl(route)};
        }
        if (route._handler_class.equals(ModelBuilderHandler.class)) {
            String[] ss = route._url_pattern_raw.split("/");
            String algoURLName = ss[3];
            int version2 = Integer.valueOf(ss[1]);
            String algoName = ModelBuilder.algoName(algoURLName);
            String schemaDir = ModelBuilder.schemaDirectory(algoURLName);
            String inputSchemaName = schemaDir + algoName + "V" + version2;
            sinput = (Schema)TypeMap.theFreezable(TypeMap.onIce(inputSchemaName));
            sinput.init_meta();
            soutput = sinput;
        } else {
            sinput = Schema.newInstance(Handler.getHandlerMethodInputSchema(route._handler_method));
            soutput = Schema.newInstance(Handler.getHandlerMethodOutputSchema(route._handler_method));
        }
        docs.routes[0].input_schema = sinput.getClass().getSimpleName();
        docs.routes[0].output_schema = soutput.getClass().getSimpleName();
        docs.routes[0].markdown = route.markdown(sinput, soutput).toString();
        return docs;
    }

    @Deprecated
    public MetadataV3 fetchSchemaMetadataByClass(int version, MetadataV3 docs) {
        SchemaMetadataBase meta;
        docs.schemas = new SchemaMetadataBase[1];
        docs.schemas[0] = meta = (SchemaMetadataBase)Schema.schema(version, SchemaMetadata.class).fillFromImpl(SchemaMetadata.createSchemaMetadata(docs.classname));
        return docs;
    }

    public MetadataV3 fetchSchemaMetadata(int version, MetadataV3 docs) {
        SchemaMetadataBase meta;
        if ("void".equals(docs.schemaname)) {
            docs.schemas = new SchemaMetadataBase[0];
            return docs;
        }
        docs.schemas = new SchemaMetadataBase[1];
        Schema schema = Schema.newInstance(docs.schemaname);
        try {
            Iced impl = (Iced)schema.getImplClass().newInstance();
            schema.fillFromImpl(impl);
        }
        catch (Exception e) {
            // empty catch block
        }
        docs.schemas[0] = meta = (SchemaMetadataBase)Schema.schema(version, SchemaMetadata.class).fillFromImpl(new SchemaMetadata(schema));
        return docs;
    }

    public MetadataV3 listSchemas(int version, MetadataV3 docs) {
        Map<String, Class<Schema>> ss = Schema.schemas();
        docs.schemas = new SchemaMetadataBase[ss.size()];
        int i = 0;
        for (Class<Schema> schema_class : ss.values()) {
            Schema schema = Schema.newInstance(schema_class);
            try {
                Iced impl = (Iced)schema.getImplClass().newInstance();
                schema.fillFromImpl(impl);
            }
            catch (Exception e) {
                // empty catch block
            }
            docs.schemas[i++] = (SchemaMetadataBase)Schema.schema(version, SchemaMetadata.class).fillFromImpl(new SchemaMetadata(schema));
        }
        return docs;
    }
}

