/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Iterator;
import water.fvec.CXIChunk;
import water.fvec.NewChunk;

public class CNAXIChunk
extends CXIChunk {
    protected CNAXIChunk(int len, int valsz, byte[] buf) {
        super(len, valsz, buf);
    }

    @Override
    public final boolean isSparseZero() {
        return false;
    }

    @Override
    public int sparseLenZero() {
        return this._len;
    }

    @Override
    public int nextNZ(int rid) {
        return rid + 1;
    }

    @Override
    public int nonzeros(int[] res) {
        for (int i = 0; i < this._len; ++i) {
            res[i] = i;
        }
        return this._len;
    }

    @Override
    public final boolean isSparseNA() {
        return true;
    }

    @Override
    public int sparseLenNA() {
        return this._sparseLen;
    }

    @Override
    public final int nextNNA(int rid) {
        int off = rid == -1 ? 6 : this.findOffset(rid);
        int x = this.getId(off);
        if (x > rid) {
            return x;
        }
        if (off < this._mem.length - this.ridsz() - this.valsz()) {
            return this.getId(off + this.ridsz() + this.valsz());
        }
        return this._len;
    }

    @Override
    public final int nonnas(int[] arr) {
        int off = 6;
        int inc = this.valsz() + this.ridsz();
        int i = 0;
        while (i < this._sparseLen) {
            arr[i] = this.getId(off);
            ++i;
            off += inc;
        }
        return this._sparseLen;
    }

    @Override
    protected long at8_impl(int idx) {
        int off = this.findOffset(idx);
        if (this.getId(off) != idx) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return this.getIValue(off);
    }

    @Override
    protected double atd_impl(int idx) {
        int off = this.findOffset(idx);
        if (this.getId(off) != idx) {
            return Double.NaN;
        }
        return this.getIValue(off);
    }

    @Override
    protected boolean isNA_impl(int i) {
        int off = this.findOffset(i);
        return this.getId(off) != i;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.setSparseNA();
        nc.alloc_mantissa(this._sparseLen);
        nc.alloc_exponent(this._sparseLen);
        nc.alloc_indices(this._sparseLen);
        int off = 6;
        int i = 0;
        while (i < this._sparseLen) {
            long v = this.getIValue(off);
            int id = this.getId(off);
            nc.addNAs(id - nc._len);
            nc.addNum(v, 0);
            ++i;
            off += this.ridsz() + this.valsz();
        }
        nc.set_len(this._len);
        return nc;
    }

    @Override
    public Iterator<CXIChunk.Value> values() {
        return new CXIChunk.SparseIterator(this, new CXIChunk.Value(){

            @Override
            public final long asLong() {
                return CNAXIChunk.this.getIValue(this._off);
            }

            @Override
            public final double asDouble() {
                return CNAXIChunk.this.getIValue(this._off);
            }

            @Override
            public final boolean isNA() {
                return false;
            }
        });
    }
}

