/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.util.VecUtils;

class ASTAsFactor
extends ASTPrim {
    ASTAsFactor() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "as.factor";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame ary = stk.track(asts[1].exec(env)).getFrame();
        Vec[] nvecs = new Vec[ary.numCols()];
        for (Vec v : ary.vecs()) {
            if (v.isCategorical() || v.isString() || v.isNumeric()) continue;
            throw new IllegalArgumentException("asfactor() requires a string, categorical, or numeric column. Received " + ary.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        for (int c = 0; c < nvecs.length; ++c) {
            Vec vv = ary.vec(c);
            try {
                nvecs[c] = vv.toCategoricalVec();
                continue;
            }
            catch (Exception e) {
                VecUtils.deleteVecs(nvecs, c);
                throw e;
            }
        }
        return new ValFrame(new Frame(ary._names, nvecs));
    }
}

