/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import java.util.HashMap;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.util.VecUtils;

class ASTTrim
extends ASTPrim {
    ASTTrim() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "trim";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        for (Vec v : fr.vecs()) {
            if (v.isCategorical() || v.isString()) continue;
            throw new IllegalArgumentException("trim() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i = 0;
        for (Vec v : fr.vecs()) {
            nvs[i] = v.isCategorical() ? this.trimCategoricalCol(v) : this.trimStringCol(v);
            ++i;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec trimCategoricalCol(Vec vec) {
        String[] doms = (String[])vec.domain().clone();
        HashMap<String, ArrayList<Integer>> trimmedToOldDomainIndices = new HashMap<String, ArrayList<Integer>>();
        for (int i = 0; i < doms.length; ++i) {
            String trimmed;
            doms[i] = trimmed = doms[i].trim();
            if (!trimmedToOldDomainIndices.containsKey(trimmed)) {
                ArrayList<Integer> val = new ArrayList<Integer>();
                val.add(i);
                trimmedToOldDomainIndices.put(trimmed, val);
                continue;
            }
            trimmedToOldDomainIndices.get(trimmed).add(i);
        }
        if (trimmedToOldDomainIndices.size() < doms.length) {
            return VecUtils.DomainDedupe.domainDeduper(vec, trimmedToOldDomainIndices);
        }
        return vec.makeCopy(doms);
    }

    private Vec trimStringCol(Vec vec) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i = 0; i < chk.len(); ++i) {
                        newChk.addNA();
                    }
                } else {
                    ((CStrChunk)chk).asciiTrim(newChk);
                }
            }
        }.doAll(new byte[]{2}, vec)).outputFrame().anyVec();
    }
}

