/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.rapids.ValNum;
import water.rapids.ValRow;

public abstract class ASTUniOp
extends ASTPrim {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    int nargs() {
        return 2;
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Val val = stk.track(asts[1].exec(env));
        switch (val.type()) {
            case 1: {
                return new ValNum(this.op(val.getNum()));
            }
            case 5: {
                Frame fr = val.getFrame();
                return new ValFrame(((MRTask)new MRTask(){

                    @Override
                    public void map(Chunk[] cs, NewChunk[] ncs) {
                        for (int col = 0; col < cs.length; ++col) {
                            Chunk c = cs[col];
                            NewChunk nc = ncs[col];
                            for (int i = 0; i < c._len; ++i) {
                                nc.addNum(ASTUniOp.this.op(c.atd(i)));
                            }
                        }
                    }
                }.doAll(fr.numCols(), (byte)3, fr)).outputFrame());
            }
            case 6: {
                ValRow v = (ValRow)val;
                double[] ds = new double[v._ds.length];
                for (int i = 0; i < ds.length; ++i) {
                    ds[i] = this.op(v._ds[i]);
                }
                String[] names = (String[])v._names.clone();
                return new ValRow(ds, names);
            }
        }
        throw H2O.unimpl("unop unimpl: " + val.getClass());
    }

    abstract double op(double var1);
}

