/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTGroup;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.util.IcedHashMap;

class ASTUnique
extends ASTPrim {
    ASTUnique() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "unique";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Vec v;
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (fr.numCols() != 1) {
            throw new IllegalArgumentException("Unique applies to a single column only.");
        }
        if (fr.anyVec().isCategorical()) {
            v = Vec.makeSeq(0L, fr.anyVec().domain().length, true);
            v.setDomain(fr.anyVec().domain());
            DKV.put(v);
        } else {
            UniqTask t = (UniqTask)new UniqTask().doAll(fr);
            int nUniq = t._uniq.size();
            final ASTGroup.G[] uniq = t._uniq.keySet().toArray(new ASTGroup.G[nUniq]);
            v = Vec.makeZero(nUniq);
            new MRTask(){

                @Override
                public void map(Chunk c) {
                    int start = (int)c.start();
                    for (int i = 0; i < c._len; ++i) {
                        c.set(i, uniq[i + start]._gs[0]);
                    }
                }
            }.doAll(v);
        }
        return new ValFrame(new Frame(v));
    }

    private static class UniqTask
    extends MRTask<UniqTask> {
        IcedHashMap<ASTGroup.G, String> _uniq;

        private UniqTask() {
        }

        @Override
        public void map(Chunk[] c) {
            this._uniq = new IcedHashMap();
            ASTGroup.G g = new ASTGroup.G(1, null);
            for (int i = 0; i < c[0]._len; ++i) {
                g.fill(i, c, new int[]{0});
                String s_old = this._uniq.putIfAbsent(g, "");
                if (s_old != null) continue;
                g = new ASTGroup.G(1, null);
            }
        }

        @Override
        public void reduce(UniqTask t) {
            if (this._uniq != t._uniq) {
                IcedHashMap<ASTGroup.G, String> l = this._uniq;
                IcedHashMap<ASTGroup.G, String> r = t._uniq;
                if (l.size() < r.size()) {
                    l = r;
                    r = this._uniq;
                }
                for (ASTGroup.G rg : r.keySet()) {
                    l.putIfAbsent(rg, "");
                }
                this._uniq = l;
                t._uniq = null;
            }
        }
    }
}

