/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.Arrays;
import water.H2O;

public final class DistributedException
extends RuntimeException {
    public DistributedException() {
        this.truncateStackTrace();
    }

    public DistributedException(Throwable cause) {
        super("DistributedException from " + H2O.SELF, cause);
        this.truncateStackTrace();
    }

    public DistributedException(String msg, Throwable cause) {
        super(msg, cause);
        try {
            this.truncateStackTrace();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return this.getMessage() + ", caused by " + this.getCause().toString();
    }

    private void truncateStackTrace() {
        int i;
        StackTraceElement[] stackTrace = this.getStackTrace();
        for (i = 0; !(i >= stackTrace.length || stackTrace[i].getFileName() != null && stackTrace[i].getFileName().equals("JettyHTTPD.java")); ++i) {
        }
        this.setStackTrace(Arrays.copyOf(stackTrace, i));
    }
}

