/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.NoSuchElementException;

class LabelledStringList {
    private Item _begin;
    private int _length = 0;
    private int _noOfElements = 0;

    LabelledStringList() {
    }

    Label begin() {
        return new Label(null);
    }

    private int length() {
        return this._noOfElements;
    }

    private void clear() {
        this._begin = null;
        this._length = 0;
        this._noOfElements = 0;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this._length);
        Item i = this._begin;
        while (i != null) {
            s.append(i.value);
            i = i.next;
        }
        return s.toString();
    }

    class Label {
        Item _prev;

        Label(Item prev) {
            this._prev = prev;
        }

        protected Label clone() {
            return new Label(this._prev);
        }

        private void insert(String value) {
            if (this._prev == null) {
                LabelledStringList.this._begin = new Item(value, LabelledStringList.this._begin);
            } else {
                this._prev.next = new Item(value, this._prev.next);
            }
            ++LabelledStringList.this._noOfElements;
            LabelledStringList.this._length += value.length();
        }

        void insertAndAdvance(String value) {
            this.insert(value);
            this._prev = this._prev == null ? LabelledStringList.this._begin : this._prev.next;
        }

        private void remove() throws NoSuchElementException {
            if (this._prev == null) {
                if (LabelledStringList.this._begin == null) {
                    throw new NoSuchElementException();
                }
                LabelledStringList.this._length -= ((LabelledStringList)LabelledStringList.this)._begin.value.length();
                LabelledStringList.this._begin = ((LabelledStringList)LabelledStringList.this)._begin.next;
            } else {
                if (this._prev.next == null) {
                    throw new NoSuchElementException();
                }
                LabelledStringList.this._length -= this._prev.next.value.length();
                this._prev.next = this._prev.next.next;
            }
            --LabelledStringList.this._noOfElements;
        }

        private void removeTill(Label other) {
            if (this._prev == null) {
                if (other._prev == null) {
                    return;
                }
                while (LabelledStringList.this._begin != null && ((LabelledStringList)LabelledStringList.this)._begin.next != other._prev.next) {
                    LabelledStringList.this._length -= ((LabelledStringList)LabelledStringList.this)._begin.value.length();
                    LabelledStringList.this._begin = ((LabelledStringList)LabelledStringList.this)._begin.next;
                    --LabelledStringList.this._noOfElements;
                }
            } else if (other._prev == null) {
                LabelledStringList.this.clear();
                this._prev = null;
            } else {
                Item end = other._prev.next;
                while (this._prev.next != null && this._prev.next != end) {
                    this.remove();
                }
            }
            other._prev = this._prev;
        }
    }

    private static class Item {
        String value;
        Item next;

        Item(String value, Item next) {
            this.value = value;
            this.next = next;
        }
    }
}

