/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Model;
import hex.ModelMetrics;
import water.H2O;
import water.fvec.Frame;

public class ModelMetricsSupervised
extends ModelMetrics {
    public final String[] _domain;
    public final double _sigma;

    public ModelMetricsSupervised(Model model, Frame frame, long nobs, double mse, String[] domain, double sigma) {
        super(model, frame, nobs, mse, null);
        this._domain = domain;
        this._sigma = sigma;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" R^2: " + (float)this.r2() + "\n");
        return sb.toString();
    }

    public final double r2() {
        double var = this._sigma * this._sigma;
        double r2 = 1.0 - this._MSE / var;
        return r2 >= 0.0 ? r2 : Double.NaN;
    }

    public static class MetricBuilderSupervised<T extends MetricBuilderSupervised<T>>
    extends ModelMetrics.MetricBuilder<T> {
        protected final String[] _domain;
        protected final int _nclasses;

        public MetricBuilderSupervised(int nclasses, String[] domain) {
            assert (domain == null || domain.length >= nclasses);
            this._nclasses = nclasses;
            this._domain = domain;
            this._work = new double[this._nclasses + 1];
        }

        @Override
        public double[] perRow(double[] ds, float[] yact, Model m) {
            throw H2O.fail("Subclasses must implement perRow.");
        }

        @Override
        public ModelMetrics makeModelMetrics(Model m, Frame f, Frame adaptedFrame, Frame preds) {
            return null;
        }
    }
}

