/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import water.AutoBuffer;
import water.H2O;
import water.Iced;
import water.api.schemas3.KeyV3;
import water.exceptions.H2OIllegalArgumentException;

public class IcedWrapper
extends Iced {
    boolean is_array;
    String t = null;
    int i;
    long l;
    float f;
    double d;
    boolean b;
    String s;
    String e;
    KeyV3 k;
    int[] i_ar;
    long[] l_ar;
    float[] f_ar;
    double[] d_ar;
    String[] s_ar;
    String[] e_ar;
    KeyV3[] k_ar;
    Iced[] iced_ar;

    public IcedWrapper(Object o) {
        if (null == o) {
            this.t = null;
            return;
        }
        this.is_array = o.getClass().isArray();
        if (this.is_array) {
            Class<?> clz = o.getClass().getComponentType();
            if (clz == Byte.class) {
                this.t = "Byte";
            } else if (clz == Byte.TYPE) {
                this.t = "B";
            } else if (clz == Integer.class) {
                this.t = "I";
                this.i_ar = ArrayUtils.toPrimitive((Integer[])((Integer[])o));
            } else if (clz == Integer.TYPE) {
                this.t = "I";
                this.i_ar = (int[])o;
            } else if (clz == Long.class) {
                this.t = "L";
                this.l_ar = ArrayUtils.toPrimitive((Long[])((Long[])o));
            } else if (clz == Long.TYPE) {
                this.t = "L";
                this.l_ar = (long[])o;
            } else if (clz == Float.class) {
                this.t = "F";
                this.f_ar = ArrayUtils.toPrimitive((Float[])((Float[])o));
            } else if (clz == Float.TYPE) {
                this.t = "F";
                this.f_ar = (float[])o;
            } else if (clz == Double.class) {
                this.t = "D";
                this.d_ar = ArrayUtils.toPrimitive((Double[])((Double[])o));
            } else if (clz == Double.TYPE) {
                this.t = "D";
                this.d_ar = (double[])o;
            } else if (clz == Boolean.class) {
                this.t = "Bo";
            } else if (clz == Boolean.TYPE) {
                this.t = "Bo";
            } else if (clz == String.class) {
                this.t = "S";
                this.s_ar = (String[])o;
            } else if (clz.isEnum()) {
                this.t = "E";
                this.e_ar = new String[Array.getLength(o)];
                for (int i = 0; i < this.e_ar.length; ++i) {
                    this.e_ar[i] = Array.get(o, i).toString();
                }
            } else if (o instanceof KeyV3[]) {
                this.t = "K";
                this.k_ar = (KeyV3[])o;
            } else if (o instanceof Iced[]) {
                this.t = "Iced";
                this.iced_ar = (Iced[])o;
            }
        } else if (o instanceof Byte) {
            this.i = ((Byte)o).byteValue();
            this.t = "B";
        } else if (o instanceof Integer) {
            this.i = (Integer)o;
            this.t = "I";
        } else if (o instanceof Long) {
            this.l = (Long)o;
            this.t = "L";
        } else if (o instanceof Float) {
            this.f = ((Float)o).floatValue();
            this.t = "F";
        } else if (o instanceof Double) {
            this.d = (Double)o;
            this.t = "D";
        } else if (o instanceof Boolean) {
            this.b = (Boolean)o;
            this.t = "Bo";
        } else if (o instanceof String) {
            this.s = (String)o;
            this.t = "S";
        } else if (o instanceof Enum) {
            this.e = ((Enum)o).toString();
            this.t = "E";
        } else if (o instanceof KeyV3) {
            this.k = (KeyV3)o;
            this.t = "K";
        }
        if (null == this.t) {
            throw new H2OIllegalArgumentException("o", "IcedWrapper", o);
        }
    }

    public Object get() {
        if (this.t == null) {
            return null;
        }
        if (this.is_array) {
            if (this.t == "byte") {
                throw H2O.fail();
            }
            if (this.t.equals("I")) {
                return this.i_ar;
            }
            if (this.t.equals("L")) {
                return this.l_ar;
            }
            if (this.t.equals("F")) {
                return this.f_ar;
            }
            if (this.t.equals("D")) {
                return this.d_ar;
            }
            if (this.t.equals("Bo")) {
                throw H2O.fail();
            }
            if (this.t.equals("S")) {
                return this.s_ar;
            }
            if (this.t.equals("E")) {
                return this.e_ar;
            }
            if (this.t.equals("K")) {
                return this.k_ar;
            }
            if (this.t.equals("Iced")) {
                return this.iced_ar;
            }
        } else {
            if (this.t.equals("B")) {
                return this.i;
            }
            if (this.t.equals("I")) {
                return this.i;
            }
            if (this.t.equals("L")) {
                return this.l;
            }
            if (this.t.equals("F")) {
                return Float.valueOf(this.f);
            }
            if (this.t.equals("D")) {
                return this.d;
            }
            if (this.t.equals("Bo")) {
                return this.b;
            }
            if (this.t.equals("S")) {
                return this.s;
            }
            if (this.t.equals("E")) {
                return this.e;
            }
            if (this.t.equals("K")) {
                return this.k;
            }
        }
        throw new H2OIllegalArgumentException(this.toString());
    }

    public String toString() {
        if (null == this.t) {
            return "(null)";
        }
        if (this.is_array) {
            if (this.t.equals("I")) {
                return Arrays.toString(this.i_ar);
            }
            if (this.t.equals("L")) {
                return Arrays.toString(this.l_ar);
            }
            if (this.t.equals("F")) {
                return Arrays.toString(this.f_ar);
            }
            if (this.t.equals("D")) {
                return Arrays.toString(this.d_ar);
            }
            if (this.t.equals("S")) {
                return Arrays.toString(this.s_ar);
            }
            if (this.t.equals("E")) {
                return Arrays.toString(this.e_ar);
            }
            if (this.t.equals("K")) {
                return Arrays.toString(this.k_ar);
            }
        } else {
            if (this.t.equals("B")) {
                return "" + this.i;
            }
            if (this.t.equals("I")) {
                return "" + this.i;
            }
            if (this.t.equals("L")) {
                return "" + this.l;
            }
            if (this.t.equals("F")) {
                return "" + this.f;
            }
            if (this.t.equals("D")) {
                return "" + this.d;
            }
            if (this.t.equals("Bo")) {
                return "" + this.b;
            }
            if (this.t.equals("S")) {
                return this.s;
            }
            if (this.t.equals("E")) {
                return "" + this.e;
            }
            if (this.t.equals("K")) {
                return "" + this.k;
            }
        }
        return "unhandled type";
    }

    public AutoBuffer writeUnwrappedJSON(AutoBuffer ab) {
        if (this.is_array) {
            if (this.t.equals("B")) {
                return ab.putJSONA4(this.i_ar);
            }
            if (this.t.equals("I")) {
                return ab.putJSONA4(this.i_ar);
            }
            if (this.t.equals("L")) {
                return ab.putJSONA8(this.l_ar);
            }
            if (this.t.equals("F")) {
                return ab.putJSONA4f(this.f_ar);
            }
            if (this.t.equals("D")) {
                return ab.putJSONA8d(this.d_ar);
            }
            if (this.t.equals("Bo")) {
                return ab.putJSONAStr(null);
            }
            if (this.t.equals("S")) {
                return ab.putJSONAStr(this.s_ar);
            }
            if (this.t.equals("E")) {
                return ab.putJSONAStr(this.e_ar);
            }
            if (this.t.equals("K")) {
                return ab.putJSONA(this.k_ar);
            }
            if (this.t.equals("Iced")) {
                return ab.putJSONA(this.iced_ar);
            }
        } else {
            if (this.t.equals("B")) {
                return ab.putJSON1((byte)this.i);
            }
            if (this.t.equals("I")) {
                return ab.putJSON4(this.i);
            }
            if (this.t.equals("L")) {
                return ab.putJSON8(this.l);
            }
            if (this.t.equals("F")) {
                return ab.putJSON4f(this.f);
            }
            if (this.t.equals("D")) {
                return ab.putJSON8d(this.d);
            }
            if (this.t.equals("Bo")) {
                return ab.putJSONStrUnquoted(this.b ? "true" : "false");
            }
            if (this.t.equals("S")) {
                return ab.putJSONName(this.s);
            }
            if (this.t.equals("E")) {
                return ab.putJSONName(this.e);
            }
            if (this.t.equals("K")) {
                return ab.putJSON(this.k);
            }
        }
        throw H2O.fail("Unhandled type: " + this.t);
    }
}

