/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.Model;
import hex.ModelBuilder;
import hex.schemas.ModelBuilderSchema;
import java.util.Properties;
import water.H2O;
import water.Job;
import water.Key;
import water.TypeMap;
import water.api.Handler;
import water.api.Route;
import water.api.Schema;
import water.api.schemas3.ModelParametersSchemaV3;
import water.util.HttpResponseStatus;
import water.util.PojoUtils;

public class ModelBuilderHandler<B extends ModelBuilder, S extends ModelBuilderSchema<B, S, P>, P extends ModelParametersSchemaV3>
extends Handler {
    S handle(int version, Route route, Properties parms) throws Exception {
        String[] ss = route._url.split("/");
        String algoURLName = ss[3];
        String algoName = ModelBuilder.algoName(algoURLName);
        String schemaDir = ModelBuilder.schemaDirectory(algoURLName);
        String schemaName = schemaDir + algoName + "V" + version;
        ModelBuilderSchema schema = (ModelBuilderSchema)TypeMap.newFreezable(schemaName);
        schema.init_meta();
        String parmName = schemaDir + algoName + "V" + version + "$" + algoName + "ParametersV" + version;
        ModelParametersSchemaV3 parmSchema = (ModelParametersSchemaV3)TypeMap.newFreezable(parmName);
        schema.parameters = parmSchema;
        String handlerName = route._handler_method.getName();
        boolean doTrain = handlerName.equals("train");
        assert (doTrain || handlerName.equals("validate_parameters"));
        String model_id = parms.getProperty("model_id");
        Key<Model> key = doTrain ? (model_id == null ? ModelBuilder.defaultKey(algoName) : Key.make(model_id)) : null;
        Job<Model> job = doTrain ? new Job<Model>(key, ModelBuilder.javaName(algoURLName), algoName) : null;
        Object builder = ModelBuilder.make(algoURLName, job, key);
        ((ModelParametersSchemaV3)schema.parameters).fillFromImpl(((ModelBuilder)builder)._parms);
        ((Schema)schema.parameters).fillFromParms(parms);
        ((ModelParametersSchemaV3)schema.parameters).fillImpl(((ModelBuilder)builder)._parms);
        ((ModelBuilder)builder).init(false);
        schema.fillFromImpl(builder);
        PojoUtils.copyProperties(schema.parameters, ((ModelBuilder)builder)._parms, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES, null, new String[]{"error_count", "messages"});
        schema.setHttpStatus(HttpResponseStatus.OK.getCode());
        if (doTrain) {
            schema.job.fillFromImpl(((ModelBuilder)builder).trainModel());
        }
        return (S)schema;
    }

    public S train(int version, S schema) {
        throw H2O.fail();
    }

    public S validate_parameters(int version, S schema) {
        throw H2O.fail();
    }
}

