/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.ModelBuilder;
import hex.schemas.ModelBuilderSchema;
import water.H2O;
import water.Iced;
import water.api.API;
import water.api.Handler;
import water.api.SchemaServer;
import water.api.schemas3.ModelBuildersV3;
import water.api.schemas3.SchemaV3;

class ModelBuildersHandler
extends Handler {
    ModelBuildersHandler() {
    }

    public ModelBuildersV3 list(int version, ModelBuildersV3 m) {
        m.model_builders = new ModelBuilderSchema.IcedHashMapStringModelBuilderSchema();
        for (String algo : ModelBuilder.algos()) {
            Object builder = ModelBuilder.make(algo, null, null);
            m.model_builders.put(algo.toLowerCase(), (ModelBuilderSchema)SchemaServer.schema(version, builder).fillFromImpl(builder));
        }
        return m;
    }

    public ModelBuildersV3 fetch(int version, ModelBuildersV3 m) {
        m.model_builders = new ModelBuilderSchema.IcedHashMapStringModelBuilderSchema();
        Object builder = ModelBuilder.make(m.algo, null, null);
        m.model_builders.put(m.algo.toLowerCase(), (ModelBuilderSchema)SchemaServer.schema(version, builder).fillFromImpl(builder));
        return m;
    }

    public ModelIdV3 calcModelId(int version, ModelBuildersV3 m) {
        m.model_builders = new ModelBuilderSchema.IcedHashMapStringModelBuilderSchema();
        String model_id = H2O.calcNextUniqueModelId(m.algo);
        ModelIdV3 mm = new ModelIdV3();
        mm.model_id = model_id;
        return mm;
    }

    public static class ModelIdV3
    extends SchemaV3<Iced, ModelIdV3> {
        @API(help="Model ID", direction=API.Direction.OUTPUT)
        String model_id;
    }
}

