/*
 * Decompiled with CFR 0.152.
 */
package water.exceptions;

import water.H2OError;
import water.exceptions.H2OAbstractRuntimeException;
import water.util.HttpResponseStatus;

public class H2OFailException
extends H2OAbstractRuntimeException {
    @Override
    protected int HTTP_RESPONSE_CODE() {
        return HttpResponseStatus.INTERNAL_SERVER_ERROR.getCode();
    }

    public H2OFailException(String message) {
        super(message, message);
        this.timestamp = System.currentTimeMillis();
    }

    public H2OFailException(String msg, Throwable cause) {
        this(msg);
        this.initCause(cause);
    }

    @Override
    public H2OError toH2OError() {
        return new H2OError(this.timestamp, null, this.getMessage(), this.dev_message, this.HTTP_RESPONSE_CODE(), this.values, this);
    }

    @Override
    public H2OError toH2OError(String error_url) {
        return new H2OError(this.timestamp, error_url, this.getMessage(), this.dev_message, this.HTTP_RESPONSE_CODE(), this.values, this);
    }
}

