/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public class C16Chunk
extends Chunk {
    public static final long _LO_NA = Long.MIN_VALUE;
    public static final long _HI_NA = 0L;

    C16Chunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length >> 4);
    }

    @Override
    protected final long at8_impl(int i) {
        throw new IllegalArgumentException("at8_abs but 16-byte UUID");
    }

    @Override
    protected final double atd_impl(int i) {
        throw new IllegalArgumentException("atd but 16-byte UUID");
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return UnsafeUtils.get8(this._mem, i << 4) == Long.MIN_VALUE && UnsafeUtils.get8(this._mem, (i << 4) + 8) == 0L;
    }

    @Override
    protected long at16l_impl(int idx) {
        long lo = UnsafeUtils.get8(this._mem, idx << 4);
        long hi = UnsafeUtils.get8(this._mem, (idx << 4) + 8);
        if (lo == Long.MIN_VALUE && hi == 0L) {
            throw new IllegalArgumentException("at16 but value is missing");
        }
        return lo;
    }

    @Override
    protected long at16h_impl(int idx) {
        long lo = UnsafeUtils.get8(this._mem, idx << 4);
        long hi = UnsafeUtils.get8(this._mem, (idx << 4) + 8);
        if (lo == Long.MIN_VALUE && hi == 0L) {
            throw new IllegalArgumentException("at16 but value is missing");
        }
        return hi;
    }

    @Override
    boolean set_impl(int idx, long l) {
        return false;
    }

    @Override
    boolean set_impl(int i, double d) {
        return false;
    }

    @Override
    boolean set_impl(int i, float f) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        UnsafeUtils.set8(this._mem, idx << 4, Long.MIN_VALUE);
        UnsafeUtils.set8(this._mem, idx << 4, 0L);
        return true;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.set_len(nc.set_sparseLen(0));
        for (int i = 0; i < this._len; ++i) {
            long lo = UnsafeUtils.get8(this._mem, i << 4);
            long hi = UnsafeUtils.get8(this._mem, (i << 4) + 8);
            if (lo == Long.MIN_VALUE && hi == 0L) {
                nc.addNA();
                continue;
            }
            nc.addUUID(lo, hi);
        }
        return nc;
    }

    @Override
    protected final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length >> 4);
        assert (this._mem.length == this._len << 4);
    }
}

