/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.Iced;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;

public abstract class Chunk
extends Iced<Chunk> {
    transient long _start = -1L;
    transient int _cidx = -1;
    public transient int _len;
    private transient Chunk _chk2;
    transient Vec _vec;
    byte[] _mem;

    public Chunk() {
    }

    private Chunk(byte[] bytes) {
        this._mem = bytes;
        this.initFromBytes();
    }

    public int asSparseDoubles(double[] vals, int[] ids) {
        return this.asSparseDoubles(vals, ids, Double.NaN);
    }

    public int asSparseDoubles(double[] vals, int[] ids, double NA) {
        if (vals.length < this.sparseLenZero()) {
            throw new IllegalArgumentException();
        }
        this.getDoubles(vals, 0, this._len);
        for (int i = 0; i < this._len; ++i) {
            ids[i] = i;
        }
        return this.len();
    }

    public double[] getDoubles(double[] vals, int from, int to) {
        return this.getDoubles(vals, from, to, Double.NaN);
    }

    public double[] getDoubles(double[] vals, int from, int to, double NA) {
        for (int i = from; i < to; ++i) {
            vals[i - from] = this.atd(i);
            if (!Double.isNaN(vals[i - from])) continue;
            vals[i - from] = NA;
        }
        return vals;
    }

    public int[] getIntegers(int[] vals, int from, int to, int NA) {
        for (int i = from; i < to; ++i) {
            double d = this.atd(i);
            if (Double.isNaN(d)) {
                vals[i] = NA;
                continue;
            }
            vals[i] = (int)d;
            if ((double)vals[i] == d) continue;
            throw new IllegalArgumentException("Calling getIntegers on non-integer column");
        }
        return vals;
    }

    public double[] getDoubles(double[] vals, int[] ids) {
        int j = 0;
        for (int i : ids) {
            vals[j++] = this.atd(i);
        }
        return vals;
    }

    public final long start() {
        return this._start;
    }

    int set_len(int len) {
        this._len = len;
        return this._len;
    }

    public int len() {
        return this._len;
    }

    public Chunk chk2() {
        return this._chk2;
    }

    public Vec vec() {
        return this._vec;
    }

    public void setVec(Vec vec) {
        this._vec = vec;
    }

    public void setStart(long start) {
        this._start = start;
    }

    public byte[] getBytes() {
        return this._mem;
    }

    public void setBytes(byte[] mem) {
        this._mem = mem;
    }

    public final void crushBytes() {
        this._mem = null;
    }

    final long at8_abs(long i) {
        long x = i - (this._start > 0L ? this._start : 0L);
        if (0L <= x && x < (long)this._len) {
            return this.at8((int)x);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i + " < " + (this._start + (long)this._len));
    }

    final double at_abs(long i) {
        long x = i - (this._start > 0L ? this._start : 0L);
        if (0L <= x && x < (long)this._len) {
            return this.atd((int)x);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i + " < " + (this._start + (long)this._len));
    }

    final boolean isNA_abs(long i) {
        long x = i - (this._start > 0L ? this._start : 0L);
        if (0L <= x && x < (long)this._len) {
            return this.isNA((int)x);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i + " < " + (this._start + (long)this._len));
    }

    final long at16l_abs(long i) {
        long x = i - (this._start > 0L ? this._start : 0L);
        if (0L <= x && x < (long)this._len) {
            return this.at16l((int)x);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i + " < " + (this._start + (long)this._len));
    }

    final long at16h_abs(long i) {
        long x = i - (this._start > 0L ? this._start : 0L);
        if (0L <= x && x < (long)this._len) {
            return this.at16h((int)x);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i + " < " + (this._start + (long)this._len));
    }

    final BufferedString atStr_abs(BufferedString bStr, long i) {
        long x = i - (this._start > 0L ? this._start : 0L);
        if (0L <= x && x < (long)this._len) {
            return this.atStr(bStr, (int)x);
        }
        throw new ArrayIndexOutOfBoundsException("" + this._start + " <= " + i + " < " + (this._start + (long)this._len));
    }

    public final double atd(int i) {
        return this._chk2 == null ? this.atd_impl(i) : this._chk2.atd_impl(i);
    }

    public final long at8(int i) {
        return this._chk2 == null ? this.at8_impl(i) : this._chk2.at8_impl(i);
    }

    public final boolean isNA(int i) {
        return this._chk2 == null ? this.isNA_impl(i) : this._chk2.isNA_impl(i);
    }

    public final long at16l(int i) {
        return this._chk2 == null ? this.at16l_impl(i) : this._chk2.at16l_impl(i);
    }

    public final long at16h(int i) {
        return this._chk2 == null ? this.at16h_impl(i) : this._chk2.at16h_impl(i);
    }

    public final BufferedString atStr(BufferedString bStr, int i) {
        return this._chk2 == null ? this.atStr_impl(bStr, i) : this._chk2.atStr_impl(bStr, i);
    }

    final void set_abs(long i, long l) {
        long x = i - this._start;
        if (0L <= x && x < (long)this._len) {
            this.set((int)x, l);
        } else {
            this._vec.set(i, l);
        }
    }

    final void set_abs(long i, double d) {
        long x = i - this._start;
        if (0L <= x && x < (long)this._len) {
            this.set((int)x, d);
        } else {
            this._vec.set(i, d);
        }
    }

    final void set_abs(long i, float f) {
        long x = i - this._start;
        if (0L <= x && x < (long)this._len) {
            this.set((int)x, f);
        } else {
            this._vec.set(i, f);
        }
    }

    final void setNA_abs(long i) {
        long x = i - this._start;
        if (0L <= x && x < (long)this._len) {
            this.setNA((int)x);
        } else {
            this._vec.setNA(i);
        }
    }

    public final void set_abs(long i, String str) {
        long x = i - this._start;
        if (0L <= x && x < (long)this._len) {
            this.set((int)x, str);
        } else {
            this._vec.set(i, str);
        }
    }

    public boolean hasFloat() {
        return true;
    }

    public boolean hasNA() {
        return true;
    }

    public void replaceAll(Chunk replacement) {
        assert (this._len == replacement._len);
        this._vec.preWriting();
        this._chk2 = replacement;
        assert (this._chk2._chk2 == null);
    }

    public Chunk deepCopy() {
        Chunk c2 = (Chunk)this.clone();
        c2._vec = null;
        c2._start = -1L;
        c2._cidx = -1;
        c2._mem = (byte[])this._mem.clone();
        return c2;
    }

    private void setWrite() {
        if (this._chk2 != null) {
            return;
        }
        assert (!(this instanceof NewChunk)) : "Cannot direct-write into a NewChunk, only append";
        this._vec.preWriting();
        this._chk2 = (Chunk)this.clone();
        assert (this._chk2._chk2 == null);
    }

    public final long set(int idx, long l) {
        this.setWrite();
        if (this._chk2.set_impl(idx, l)) {
            return l;
        }
        this._chk2 = this.inflate_impl(new NewChunk(this));
        this._chk2.set_impl(idx, l);
        return l;
    }

    public final double[] set(double[] d) {
        assert (d.length == this._len && this._chk2 == null);
        this._chk2 = new NewChunk(this, d);
        return d;
    }

    public final double set(int idx, double d) {
        this.setWrite();
        if (this._chk2.set_impl(idx, d)) {
            return d;
        }
        this._chk2 = this.inflate_impl(new NewChunk(this));
        this._chk2.set_impl(idx, d);
        return d;
    }

    public final float set(int idx, float f) {
        this.setWrite();
        if (this._chk2.set_impl(idx, f)) {
            return f;
        }
        this._chk2 = this.inflate_impl(new NewChunk(this));
        this._chk2.set_impl(idx, f);
        return f;
    }

    public final boolean setNA(int idx) {
        this.setWrite();
        if (this._chk2.setNA_impl(idx)) {
            return true;
        }
        this._chk2 = this.inflate_impl(new NewChunk(this));
        this._chk2.setNA_impl(idx);
        return true;
    }

    public final String set(int idx, String str) {
        this.setWrite();
        if (this._chk2.set_impl(idx, str)) {
            return str;
        }
        this._chk2 = this.inflate_impl(new NewChunk(this));
        this._chk2.set_impl(idx, str);
        return str;
    }

    public Futures close(int cidx, Futures fs) {
        if (this instanceof NewChunk) {
            this._chk2 = this;
        }
        if (this._chk2 == null) {
            return fs;
        }
        if (this._chk2 instanceof NewChunk) {
            this._chk2 = ((NewChunk)this._chk2).new_close();
        }
        DKV.put(this._vec.chunkKey(cidx), this._chk2, fs, true);
        return fs;
    }

    public int cidx() {
        assert (this._cidx != -1) : "Chunk idx was not properly loaded!";
        return this._cidx;
    }

    abstract double atd_impl(int var1);

    abstract long at8_impl(int var1);

    abstract boolean isNA_impl(int var1);

    long at16l_impl(int idx) {
        throw new IllegalArgumentException("Not a UUID");
    }

    long at16h_impl(int idx) {
        throw new IllegalArgumentException("Not a UUID");
    }

    BufferedString atStr_impl(BufferedString bStr, int idx) {
        throw new IllegalArgumentException("Not a String");
    }

    abstract boolean set_impl(int var1, long var2);

    abstract boolean set_impl(int var1, double var2);

    abstract boolean set_impl(int var1, float var2);

    abstract boolean setNA_impl(int var1);

    boolean set_impl(int idx, String str) {
        throw new IllegalArgumentException("Not a String");
    }

    public boolean isSparseZero() {
        return false;
    }

    public int sparseLenZero() {
        return this._len;
    }

    public int nextNZ(int rid) {
        return rid + 1;
    }

    public int nonzeros(int[] res) {
        int k = 0;
        for (int i = 0; i < this._len; ++i) {
            if (this.atd(i) == 0.0) continue;
            res[k++] = i;
        }
        return k;
    }

    public boolean isSparseNA() {
        return false;
    }

    public int sparseLenNA() {
        return this._len;
    }

    public int nextNNA(int rid) {
        return rid + 1;
    }

    public int nonnas(int[] res) {
        for (int i = 0; i < this._len; ++i) {
            res[i] = i;
        }
        return this._len;
    }

    double min() {
        return Double.NaN;
    }

    double max() {
        return Double.NaN;
    }

    public NewChunk inflate() {
        return this.inflate_impl(new NewChunk(this));
    }

    public abstract NewChunk inflate_impl(NewChunk var1);

    public Chunk nextChunk() {
        return this._vec.nextChunk(this);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public long byteSize() {
        long s = this._mem == null ? 0L : (long)this._mem.length;
        s += 68L;
        if (this._chk2 != null) {
            s += this._chk2.byteSize();
        }
        return s;
    }

    public final AutoBuffer write_impl(AutoBuffer bb) {
        return bb.putA1(this._mem);
    }

    @Override
    public final byte[] asBytes() {
        return this._mem;
    }

    @Override
    public final Chunk reloadFromBytes(byte[] ary) {
        this._mem = ary;
        this.initFromBytes();
        return this;
    }

    protected abstract void initFromBytes();

    public final Chunk read_impl(AutoBuffer ab) {
        this._mem = ab.getA1();
        this.initFromBytes();
        return this;
    }

    public byte precision() {
        return -1;
    }

    public final void reportBrokenCategorical(int i, int j, long l, int[] cmap, int levels) {
        int k;
        StringBuilder sb = new StringBuilder("Categorical renumber task, column # " + i + ": Found OOB index " + l + " (expected 0 - " + cmap.length + ", global domain has " + levels + " levels) pulled from " + this.getClass().getSimpleName() + "\n");
        for (k = 0; k < Math.min(5, this._len); ++k) {
            sb.append("at8_abs[" + ((long)k + this._start) + "] = " + this.atd(k) + ", _chk2 = " + (this._chk2 != null ? Double.valueOf(this._chk2.atd(k)) : "") + "\n");
        }
        sb.append("...\n");
        for (k = Math.max(k, j - 2); k < Math.min(this._len, j + 2); ++k) {
            sb.append("at8_abs[" + ((long)k + this._start) + "] = " + this.atd(k) + ", _chk2 = " + (this._chk2 != null ? Double.valueOf(this._chk2.atd(k)) : "") + "\n");
        }
        sb.append("...\n");
        for (k = Math.max(k, this._len - 5); k < this._len; ++k) {
            sb.append("at8_abs[" + ((long)k + this._start) + "] = " + this.atd(k) + ", _chk2 = " + (this._chk2 != null ? Double.valueOf(this._chk2.atd(k)) : "") + "\n");
        }
        throw new RuntimeException(sb.toString());
    }
}

