/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import water.parser.BufferedString;

public class ParseUUID {
    public static final boolean isUUID(BufferedString str) {
        int old = str.getOffset();
        ParseUUID.attemptUUIDParseLow(str);
        ParseUUID.attemptUUIDParseHigh(str);
        boolean res = str.getOffset() != -1;
        str.setOff(old);
        return res;
    }

    public static long[] attemptUUIDParse(BufferedString str) {
        long[] uuid = new long[2];
        uuid[0] = ParseUUID.attemptUUIDParseLow(str);
        if (str.getOffset() == -1) {
            return ParseUUID.badUUID();
        }
        uuid[1] = ParseUUID.attemptUUIDParseHigh(str);
        if (str.getOffset() == -1) {
            return ParseUUID.badUUID();
        }
        return uuid;
    }

    private static long attemptUUIDParseLow(BufferedString str) {
        byte[] buf = str.getBuffer();
        int i = str.getOffset();
        if (i + 36 > buf.length) {
            return ParseUUID.markBad(str);
        }
        long lo = 0L;
        lo = ParseUUID.get2(lo, buf, (i += 2) - 2);
        lo = ParseUUID.get2(lo, buf, (i += 2) - 2);
        lo = ParseUUID.get2(lo, buf, (i += 2) - 2);
        lo = ParseUUID.get2(lo, buf, (i += 2) - 2);
        if (buf[i++] != 45) {
            return ParseUUID.markBad(str);
        }
        lo = ParseUUID.get2(lo, buf, (i += 2) - 2);
        lo = ParseUUID.get2(lo, buf, (i += 2) - 2);
        if (buf[i++] != 45) {
            return ParseUUID.markBad(str);
        }
        lo = ParseUUID.get2(lo, buf, (i += 2) - 2);
        return ParseUUID.attemptUUIDParseEnd(str, lo, buf, i);
    }

    public static long attemptUUIDParseHigh(BufferedString str) {
        byte[] buf = str.getBuffer();
        int i = str.getOffset();
        if (i == -1) {
            return ParseUUID.markBad(str);
        }
        long hi = 0L;
        if (buf[i++] != 45) {
            return ParseUUID.markBad(str);
        }
        hi = ParseUUID.get2(hi, buf, (i += 2) - 2);
        hi = ParseUUID.get2(hi, buf, (i += 2) - 2);
        if (buf[i++] != 45) {
            return ParseUUID.markBad(str);
        }
        hi = ParseUUID.get2(hi, buf, (i += 2) - 2);
        hi = ParseUUID.get2(hi, buf, (i += 2) - 2);
        hi = ParseUUID.get2(hi, buf, (i += 2) - 2);
        hi = ParseUUID.get2(hi, buf, (i += 2) - 2);
        hi = ParseUUID.get2(hi, buf, (i += 2) - 2);
        return ParseUUID.attemptUUIDParseEnd(str, hi, buf, i);
    }

    private static long attemptUUIDParseEnd(BufferedString str, long lo, byte[] buf, int i) {
        if (lo == Long.MIN_VALUE) {
            return ParseUUID.markBad(str);
        }
        str.setOff(i + 2);
        if (lo == 0x80000000000000L && buf[i] == 48 && buf[i + 1] == 48) {
            return Long.MIN_VALUE;
        }
        return (lo = ParseUUID.get2(lo, buf, i)) == Long.MIN_VALUE || i + 2 < buf.length && ParseUUID.hdigit(0L, buf[i + 2]) != Long.MIN_VALUE ? ParseUUID.markBad(str) : lo;
    }

    private static long get2(long x, byte[] buf, int i) {
        if (x == Long.MIN_VALUE) {
            return x;
        }
        x = ParseUUID.hdigit(x, buf[i++]);
        x = ParseUUID.hdigit(x, buf[i++]);
        return x;
    }

    private static long hdigit(long x, byte b) {
        if (x == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        if (b >= 48 && b <= 57) {
            return (x << 4) + (long)b - 48L;
        }
        if (b >= 65 && b <= 70) {
            return (x << 4) + (long)b - 65L + 10L;
        }
        if (b >= 97 && b <= 102) {
            return (x << 4) + (long)b - 97L + 10L;
        }
        return Long.MIN_VALUE;
    }

    private static long markBad(BufferedString str) {
        str.setOff(-1);
        return Long.MIN_VALUE;
    }

    private static long[] badUUID() {
        return new long[]{Long.MIN_VALUE, 0L};
    }
}

