/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import water.Freezable;
import water.Iced;
import water.parser.BufferedString;

public interface ParseWriter
extends Freezable {
    public void setColumnNames(String[] var1);

    public void newLine();

    public boolean isString(int var1);

    public void addNumCol(int var1, long var2, int var4);

    public void addNumCol(int var1, double var2);

    public void addInvalidCol(int var1);

    public void addStrCol(int var1, BufferedString var2);

    public void rollbackLine();

    public void invalidLine(ParseErr var1);

    public void addError(ParseErr var1);

    public void setIsAllASCII(int var1, boolean var2);

    public boolean hasErrors();

    public ParseErr[] removeErrors();

    public long lineNum();

    public static class ParseErr
    extends Iced {
        String _file = "unknown";
        String _err = "unknown";
        long _byteOffset = -1L;
        int _cidx = -1;
        long _lineNum = -1L;
        long _gLineNum = -1L;

        public ParseErr() {
        }

        public ParseErr(String err, int cidx, long lineNum, long byteOff) {
            this._err = err;
            this._cidx = cidx;
            this._lineNum = lineNum;
            this._byteOffset = byteOff;
        }

        public String toString() {
            return "ParseError at file " + this._file + (this._gLineNum == -1L ? "" : " at line " + this._lineNum + " ( destination line " + this._gLineNum + " )") + "  at byte offset " + this._byteOffset + "; error = '" + this._err + "'";
        }
    }
}

