/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import water.AutoBuffer;
import water.H2O;
import water.Key;
import water.Value;
import water.exceptions.H2ONotFoundArgumentException;
import water.fvec.NFSFileVec;
import water.persist.Persist;
import water.util.FileIntegrityChecker;
import water.util.Log;

public final class PersistNFS
extends Persist {
    static final String KEY_PREFIX = "nfs:" + File.separator;
    static final int KEY_PREFIX_LENGTH = KEY_PREFIX.length();

    public static Key decodeFile(File f) {
        return Key.make(KEY_PREFIX + f.toString());
    }

    private static File getFileForKey(Key k) {
        int off;
        int n = off = k._kb[0] == 5 ? 10 : 0;
        assert (new String(k._kb, off, KEY_PREFIX_LENGTH).equals(KEY_PREFIX)) : "Not an NFS key: " + k;
        String s = new String(k._kb, KEY_PREFIX_LENGTH + off, k._kb.length - (KEY_PREFIX_LENGTH + off));
        return new File(s);
    }

    @Override
    public void cleanUp() {
    }

    public static InputStream openStream(Key k) throws IOException {
        return new FileInputStream(PersistNFS.getFileForKey(k));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] load(Value v) throws IOException {
        byte[] byArray;
        block7: {
            assert (v.isPersisted());
            Key k = v._key;
            long skip = k.isChunkKey() ? NFSFileVec.chunkOffset(k) : 0L;
            FileInputStream s = null;
            try {
                s = new FileInputStream(PersistNFS.getFileForKey(k));
                FileChannel fc = s.getChannel();
                fc.position(skip);
                AutoBuffer ab = new AutoBuffer(fc, true, 4);
                byte[] b = ab.getA1(v._max);
                ab.close();
                byArray = b;
                if (s == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        s.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Log.debug("[h2o] Problem ignored: " + e.toString());
                    return null;
                }
            }
            s.close();
        }
        return byArray;
    }

    @Override
    public void store(Value v) {
        if (!v._key.home()) {
            return;
        }
        if (v.isPersisted()) {
            return;
        }
        try {
            File f = PersistNFS.getFileForKey(v._key);
            if (!f.mkdirs()) {
                throw new IOException("Unable to create directory " + f);
            }
            FileOutputStream s = new FileOutputStream(f);
            Throwable throwable = null;
            try {
                byte[] m = v.memOrLoad();
                assert (m == null || m.length == v._max);
                if (m != null) {
                    new AutoBuffer(s.getChannel(), false, 4).putA1(m, m.length).close();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (s != null) {
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        s.close();
                    }
                }
            }
        }
        catch (IOException e) {
            Log.err(e);
        }
    }

    @Override
    public void delete(Value v) {
        throw H2O.fail();
    }

    @Override
    public Key uriToKey(URI uri) {
        return NFSFileVec.make((File)(uri.getScheme() == null ? new File((String)uri.toString()) : new File((URI)uri)))._key;
    }

    public ArrayList<String> calcTypeaheadMatches(String filter, int limit) {
        File base = null;
        String filterPrefix = "";
        if (limit == 0) {
            --limit;
        }
        if (!filter.isEmpty()) {
            File file = new File(filter);
            if (file.isDirectory()) {
                base = file;
            } else {
                base = file.getParentFile();
                filterPrefix = file.getName().toLowerCase();
            }
        }
        if (base == null) {
            base = new File(".");
        }
        ArrayList<String> array = new ArrayList<String>();
        File[] files = base.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isHidden()) continue;
                if (file.getName().toLowerCase().startsWith(filterPrefix)) {
                    array.add(file.getPath());
                }
                if (array.size() == limit) break;
            }
        }
        return array;
    }

    @Override
    public void importFiles(String path, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        File f = new File(path);
        if (!f.exists()) {
            throw new H2ONotFoundArgumentException("File " + path + " does not exist");
        }
        FileIntegrityChecker.check(f).syncDirectory(files, keys, fails, dels);
    }
}

