/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.HashMap;
import water.H2O;
import water.Iced;
import water.fvec.Frame;
import water.rapids.ASTACos;
import water.rapids.ASTACosh;
import water.rapids.ASTASin;
import water.rapids.ASTASinh;
import water.rapids.ASTATan;
import water.rapids.ASTATanh;
import water.rapids.ASTAbs;
import water.rapids.ASTAll;
import water.rapids.ASTAnd;
import water.rapids.ASTAny;
import water.rapids.ASTAnyFactor;
import water.rapids.ASTAnyNA;
import water.rapids.ASTAppend;
import water.rapids.ASTApply;
import water.rapids.ASTAsCharacter;
import water.rapids.ASTAsFactor;
import water.rapids.ASTAsNumeric;
import water.rapids.ASTAssign;
import water.rapids.ASTCBind;
import water.rapids.ASTCeiling;
import water.rapids.ASTColNames;
import water.rapids.ASTColPySlice;
import water.rapids.ASTColSlice;
import water.rapids.ASTComma;
import water.rapids.ASTCorrelation;
import water.rapids.ASTCos;
import water.rapids.ASTCosPi;
import water.rapids.ASTCosh;
import water.rapids.ASTCountMatches;
import water.rapids.ASTCountSubstringsWords;
import water.rapids.ASTCumMax;
import water.rapids.ASTCumMin;
import water.rapids.ASTCumProd;
import water.rapids.ASTCumSum;
import water.rapids.ASTCut;
import water.rapids.ASTDay;
import water.rapids.ASTDayOfWeek;
import water.rapids.ASTDdply;
import water.rapids.ASTDiGamma;
import water.rapids.ASTDiffLag1;
import water.rapids.ASTDiv;
import water.rapids.ASTEQ;
import water.rapids.ASTEntropy;
import water.rapids.ASTExp;
import water.rapids.ASTExpm1;
import water.rapids.ASTFilterNACols;
import water.rapids.ASTFlatten;
import water.rapids.ASTFloor;
import water.rapids.ASTGE;
import water.rapids.ASTGT;
import water.rapids.ASTGamma;
import water.rapids.ASTGetTimeZone;
import water.rapids.ASTGroup;
import water.rapids.ASTGroupedPermute;
import water.rapids.ASTHist;
import water.rapids.ASTHour;
import water.rapids.ASTId;
import water.rapids.ASTIfElse;
import water.rapids.ASTImpute;
import water.rapids.ASTIntDiv;
import water.rapids.ASTIntDivR;
import water.rapids.ASTIsCharacter;
import water.rapids.ASTIsFactor;
import water.rapids.ASTIsNA;
import water.rapids.ASTIsNumeric;
import water.rapids.ASTKFold;
import water.rapids.ASTLAnd;
import water.rapids.ASTLE;
import water.rapids.ASTLGamma;
import water.rapids.ASTLOr;
import water.rapids.ASTLStrip;
import water.rapids.ASTLT;
import water.rapids.ASTLevels;
import water.rapids.ASTListTimeZones;
import water.rapids.ASTLog;
import water.rapids.ASTLog10;
import water.rapids.ASTLog1p;
import water.rapids.ASTLog2;
import water.rapids.ASTLs;
import water.rapids.ASTMMult;
import water.rapids.ASTMatch;
import water.rapids.ASTMax;
import water.rapids.ASTMaxNA;
import water.rapids.ASTMean;
import water.rapids.ASTMedian;
import water.rapids.ASTMerge;
import water.rapids.ASTMillis;
import water.rapids.ASTMin;
import water.rapids.ASTMinNA;
import water.rapids.ASTMinute;
import water.rapids.ASTMktime;
import water.rapids.ASTMod;
import water.rapids.ASTModR;
import water.rapids.ASTMode;
import water.rapids.ASTModuloKFold;
import water.rapids.ASTMonth;
import water.rapids.ASTMul;
import water.rapids.ASTNACnt;
import water.rapids.ASTNAOmit;
import water.rapids.ASTNE;
import water.rapids.ASTNLevels;
import water.rapids.ASTNcol;
import water.rapids.ASTNoOp;
import water.rapids.ASTNot;
import water.rapids.ASTNrow;
import water.rapids.ASTNum;
import water.rapids.ASTOr;
import water.rapids.ASTPlus;
import water.rapids.ASTPow;
import water.rapids.ASTProd;
import water.rapids.ASTProdNA;
import water.rapids.ASTQtile;
import water.rapids.ASTRBind;
import water.rapids.ASTRStrip;
import water.rapids.ASTReLevel;
import water.rapids.ASTRectangleAssign;
import water.rapids.ASTRename;
import water.rapids.ASTRepLen;
import water.rapids.ASTReplaceAll;
import water.rapids.ASTReplaceFirst;
import water.rapids.ASTRm;
import water.rapids.ASTRound;
import water.rapids.ASTRowSlice;
import water.rapids.ASTRunif;
import water.rapids.ASTScale;
import water.rapids.ASTSdev;
import water.rapids.ASTSecond;
import water.rapids.ASTSeq;
import water.rapids.ASTSeqLen;
import water.rapids.ASTSetDomain;
import water.rapids.ASTSetLevel;
import water.rapids.ASTSetTimeZone;
import water.rapids.ASTSgn;
import water.rapids.ASTSignif;
import water.rapids.ASTSin;
import water.rapids.ASTSinPi;
import water.rapids.ASTSinh;
import water.rapids.ASTSqrt;
import water.rapids.ASTStr;
import water.rapids.ASTStrLength;
import water.rapids.ASTStrSplit;
import water.rapids.ASTStratifiedKFold;
import water.rapids.ASTStratifiedSplit;
import water.rapids.ASTSub;
import water.rapids.ASTSubstring;
import water.rapids.ASTSum;
import water.rapids.ASTSumNA;
import water.rapids.ASTTable;
import water.rapids.ASTTan;
import water.rapids.ASTTanPi;
import water.rapids.ASTTanh;
import water.rapids.ASTTmpAssign;
import water.rapids.ASTToLower;
import water.rapids.ASTToUpper;
import water.rapids.ASTTranspose;
import water.rapids.ASTTriGamma;
import water.rapids.ASTTrim;
import water.rapids.ASTTrunc;
import water.rapids.ASTUnique;
import water.rapids.ASTVariance;
import water.rapids.ASTWeek;
import water.rapids.ASTWhich;
import water.rapids.ASTYear;
import water.rapids.ASTasDate;
import water.rapids.Env;
import water.rapids.Val;

public abstract class AST
extends Iced<AST> {
    static final HashMap<String, AST> PRIMS = new HashMap();

    public abstract Val exec(Env var1);

    public Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        throw H2O.fail();
    }

    public abstract String str();

    public String toString() {
        return this.str();
    }

    public abstract String example();

    public abstract String description();

    abstract int nargs();

    int[] columns(String[] names) {
        throw new IllegalArgumentException("Requires a number-list, but found a " + this.getClass());
    }

    static void init(AST ast) {
        PRIMS.put(ast.str(), ast);
    }

    public static ASTId newASTFrame(Frame f) {
        return new ASTId(f._key.toString());
    }

    public static ASTStr newASTStr(String s) {
        return new ASTStr(s);
    }

    static {
        AST.init(new ASTNum(0.0){

            @Override
            public String str() {
                return "FALSE";
            }
        });
        AST.init(new ASTNum(1.0){

            @Override
            public String str() {
                return "TRUE";
            }
        });
        AST.init(new ASTNum(Double.NaN){

            @Override
            public String str() {
                return "NaN";
            }
        });
        AST.init(new ASTNum(Double.NaN){

            @Override
            public String str() {
                return "NA";
            }
        });
        AST.init(new ASTACos());
        AST.init(new ASTACosh());
        AST.init(new ASTASin());
        AST.init(new ASTASinh());
        AST.init(new ASTATan());
        AST.init(new ASTATanh());
        AST.init(new ASTAbs());
        AST.init(new ASTCeiling());
        AST.init(new ASTCos());
        AST.init(new ASTCosPi());
        AST.init(new ASTCosh());
        AST.init(new ASTDiGamma());
        AST.init(new ASTExp());
        AST.init(new ASTExpm1());
        AST.init(new ASTFloor());
        AST.init(new ASTGamma());
        AST.init(new ASTIsCharacter());
        AST.init(new ASTIsNA());
        AST.init(new ASTIsNumeric());
        AST.init(new ASTLGamma());
        AST.init(new ASTLevels());
        AST.init(new ASTLog());
        AST.init(new ASTLog10());
        AST.init(new ASTLog1p());
        AST.init(new ASTLog2());
        AST.init(new ASTNLevels());
        AST.init(new ASTNcol());
        AST.init(new ASTNot());
        AST.init(new ASTNrow());
        AST.init(new ASTRound());
        AST.init(new ASTSgn());
        AST.init(new ASTSignif());
        AST.init(new ASTSin());
        AST.init(new ASTSinPi());
        AST.init(new ASTSinh());
        AST.init(new ASTSqrt());
        AST.init(new ASTTan());
        AST.init(new ASTTanPi());
        AST.init(new ASTTanh());
        AST.init(new ASTTriGamma());
        AST.init(new ASTTrunc());
        AST.init(new ASTNoOp());
        AST.init(new ASTAnd());
        AST.init(new ASTDiv());
        AST.init(new ASTIntDiv());
        AST.init(new ASTIntDivR());
        AST.init(new ASTMod());
        AST.init(new ASTModR());
        AST.init(new ASTMul());
        AST.init(new ASTOr());
        AST.init(new ASTPlus());
        AST.init(new ASTPow());
        AST.init(new ASTScale());
        AST.init(new ASTSub());
        AST.init(new ASTGE());
        AST.init(new ASTGT());
        AST.init(new ASTLE());
        AST.init(new ASTLT());
        AST.init(new ASTEQ());
        AST.init(new ASTNE());
        AST.init(new ASTLAnd());
        AST.init(new ASTLOr());
        AST.init(new ASTIfElse());
        AST.init(new ASTAll());
        AST.init(new ASTAny());
        AST.init(new ASTAnyNA());
        AST.init(new ASTCumMax());
        AST.init(new ASTCumMin());
        AST.init(new ASTCumProd());
        AST.init(new ASTCumSum());
        AST.init(new ASTMax());
        AST.init(new ASTMaxNA());
        AST.init(new ASTMean());
        AST.init(new ASTMedian());
        AST.init(new ASTMin());
        AST.init(new ASTMinNA());
        AST.init(new ASTProd());
        AST.init(new ASTProdNA());
        AST.init(new ASTSdev());
        AST.init(new ASTSum());
        AST.init(new ASTSumNA());
        AST.init(new ASTNACnt());
        AST.init(new ASTDay());
        AST.init(new ASTDay());
        AST.init(new ASTDayOfWeek());
        AST.init(new ASTGetTimeZone());
        AST.init(new ASTHour());
        AST.init(new ASTListTimeZones());
        AST.init(new ASTMillis());
        AST.init(new ASTMinute());
        AST.init(new ASTMktime());
        AST.init(new ASTMonth());
        AST.init(new ASTSecond());
        AST.init(new ASTSetTimeZone());
        AST.init(new ASTWeek());
        AST.init(new ASTYear());
        AST.init(new ASTasDate());
        AST.init(new ASTDiffLag1());
        AST.init(new ASTHist());
        AST.init(new ASTImpute());
        AST.init(new ASTMode());
        AST.init(new ASTQtile());
        AST.init(new ASTRunif());
        AST.init(new ASTStratifiedSplit());
        AST.init(new ASTTable());
        AST.init(new ASTUnique());
        AST.init(new ASTVariance());
        AST.init(new ASTCorrelation());
        AST.init(new ASTAnyFactor());
        AST.init(new ASTAsFactor());
        AST.init(new ASTAsCharacter());
        AST.init(new ASTAsNumeric());
        AST.init(new ASTCBind());
        AST.init(new ASTColNames());
        AST.init(new ASTColSlice());
        AST.init(new ASTColPySlice());
        AST.init(new ASTFilterNACols());
        AST.init(new ASTFlatten());
        AST.init(new ASTIsFactor());
        AST.init(new ASTRename());
        AST.init(new ASTRBind());
        AST.init(new ASTRowSlice());
        AST.init(new ASTSetDomain());
        AST.init(new ASTSetLevel());
        AST.init(new ASTReLevel());
        AST.init(new ASTNAOmit());
        AST.init(new ASTAppend());
        AST.init(new ASTAssign());
        AST.init(new ASTRectangleAssign());
        AST.init(new ASTRm());
        AST.init(new ASTTmpAssign());
        AST.init(new ASTTranspose());
        AST.init(new ASTMMult());
        AST.init(new ASTCut());
        AST.init(new ASTDdply());
        AST.init(new ASTGroup());
        AST.init(new ASTGroupedPermute());
        AST.init(new ASTMerge());
        AST.init(new ASTQtile());
        AST.init(new ASTStrSplit());
        AST.init(new ASTReplaceFirst());
        AST.init(new ASTReplaceAll());
        AST.init(new ASTTrim());
        AST.init(new ASTToLower());
        AST.init(new ASTCountMatches());
        AST.init(new ASTToUpper());
        AST.init(new ASTStrLength());
        AST.init(new ASTSubstring());
        AST.init(new ASTLStrip());
        AST.init(new ASTRStrip());
        AST.init(new ASTEntropy());
        AST.init(new ASTCountSubstringsWords());
        AST.init(new ASTApply());
        AST.init(new ASTComma());
        AST.init(new ASTLs());
        AST.init(new ASTMatch());
        AST.init(new ASTWhich());
        AST.init(new ASTRepLen());
        AST.init(new ASTSeq());
        AST.init(new ASTSeqLen());
        AST.init(new ASTKFold());
        AST.init(new ASTModuloKFold());
        AST.init(new ASTStratifiedKFold());
    }
}

