/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.H2O;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;

class ASTAppend
extends ASTPrim {
    ASTAppend() {
    }

    @Override
    public String[] args() {
        return new String[]{"dst", "src", "colName"};
    }

    @Override
    int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "append";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame dst = stk.track(asts[1].exec(env)).getFrame();
        Val vsrc = stk.track(asts[2].exec(env));
        String newColName = asts[3].exec(env).getStr();
        Vec vec = dst.anyVec();
        switch (vsrc.type()) {
            case 1: {
                vec = vec.makeCon(vsrc.getNum());
                break;
            }
            case 3: {
                throw H2O.unimpl();
            }
            case 5: {
                if (vsrc.getFrame().numCols() != 1) {
                    throw new IllegalArgumentException("Can only append one column");
                }
                vec = vsrc.getFrame().anyVec();
                break;
            }
            default: {
                throw new IllegalArgumentException("Source must be a Frame or Number, but found a " + vsrc.getClass());
            }
        }
        dst = new Frame((String[])dst._names.clone(), (Vec[])dst.vecs().clone());
        dst.add(newColName, vec);
        return new ValFrame(dst);
    }
}

