/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.rapids.ValNum;
import water.util.ArrayUtils;

class ASTCorrelation
extends ASTPrim {
    ASTCorrelation() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "x", "y", "use"};
    }

    @Override
    int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "cor";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Mode mode;
        String use;
        Frame frx = stk.track(asts[1].exec(env)).getFrame();
        Frame fry = stk.track(asts[2].exec(env)).getFrame();
        if (frx.numRows() != fry.numRows()) {
            throw new IllegalArgumentException("Frames must have the same number of rows, found " + frx.numRows() + " and " + fry.numRows());
        }
        String string = use = stk.track(asts[3].exec(env)).getStr();
        int n = -1;
        switch (string.hashCode()) {
            case 401590963: {
                if (!string.equals("everything")) break;
                n = 0;
                break;
            }
            case -913287373: {
                if (!string.equals("all.obs")) break;
                n = 1;
                break;
            }
            case -411139381: {
                if (!string.equals("complete.obs")) break;
                n = 2;
            }
        }
        switch (n) {
            case 0: {
                mode = Mode.Everything;
                break;
            }
            case 1: {
                mode = Mode.AllObs;
                break;
            }
            case 2: {
                mode = Mode.CompleteObs;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown use mode: " + use);
            }
        }
        return fry.numRows() == 1L ? this.scalar(frx, fry, mode) : this.array(frx, fry, mode);
    }

    private ValNum scalar(Frame frx, Frame fry, Mode mode) {
        double yval;
        double xval;
        if (frx.numCols() != fry.numCols()) {
            throw new IllegalArgumentException("Single rows must have the same number of columns, found " + frx.numCols() + " and " + fry.numCols());
        }
        Vec[] vecxs = frx.vecs();
        Vec[] vecys = fry.vecs();
        double xmean = 0.0;
        double ymean = 0.0;
        double xvar = 0.0;
        double yvar = 0.0;
        double xsd = 0.0;
        double ysd = 0.0;
        double ncols = frx.numCols();
        double NACount = 0.0;
        double ss = 0.0;
        int r = 0;
        while ((double)r < ncols) {
            xval = vecxs[r].at(0L);
            yval = vecys[r].at(0L);
            if (Double.isNaN(xval) || Double.isNaN(yval)) {
                NACount += 1.0;
            } else {
                xmean += xval;
                ymean += yval;
            }
            ++r;
        }
        xmean /= ncols - NACount;
        ymean /= ncols - NACount;
        r = 0;
        while ((double)r < ncols) {
            xval = vecxs[r].at(0L);
            yval = vecys[r].at(0L);
            if (!Double.isNaN(xval) && !Double.isNaN(yval)) {
                xvar += Math.pow(vecxs[r].at(0L) - xmean, 2.0);
            }
            yvar += Math.pow(vecys[r].at(0L) - ymean, 2.0);
            ss += (vecxs[r].at(0L) - xmean) * (vecys[r].at(0L) - ymean);
            ++r;
        }
        xsd = Math.sqrt(xvar / (double)frx.numRows());
        ysd = Math.sqrt(yvar / (double)fry.numRows());
        double cor_denom = xsd * ysd;
        if (NACount != 0.0) {
            if (mode.equals((Object)Mode.AllObs)) {
                throw new IllegalArgumentException("Mode is 'all.obs' but NAs are present");
            }
            if (mode.equals((Object)Mode.Everything)) {
                return new ValNum(Double.NaN);
            }
        }
        int r2 = 0;
        while ((double)r2 < ncols) {
            xval = vecxs[r2].at(0L);
            yval = vecys[r2].at(0L);
            if (!Double.isNaN(xval) && !Double.isNaN(yval)) {
                ss += (vecxs[r2].at(0L) - xmean) * (vecys[r2].at(0L) - ymean);
            }
            ++r2;
        }
        return new ValNum(ss / cor_denom);
    }

    private Val array(Frame frx, Frame fry, Mode mode) {
        Vec[] vecxs = frx.vecs();
        int ncolx = vecxs.length;
        Vec[] vecys = fry.vecs();
        int ncoly = vecys.length;
        if (mode.equals((Object)Mode.Everything) || mode.equals((Object)Mode.AllObs)) {
            if (mode.equals((Object)Mode.AllObs)) {
                for (Vec v : vecxs) {
                    if (v.naCnt() == 0L) continue;
                    throw new IllegalArgumentException("Mode is 'all.obs' but NAs are present");
                }
            }
            CorTaskEverything[] cvs = new CorTaskEverything[ncoly];
            double[] xmeans = new double[ncolx];
            for (int x = 0; x < ncolx; ++x) {
                xmeans[x] = vecxs[x].mean();
            }
            for (int y = 0; y < ncoly; ++y) {
                cvs[y] = (CorTaskEverything)new CorTaskEverything(vecys[y].mean(), xmeans).dfork(new Frame(vecys[y]).add(frx));
            }
            if (ncolx == 1 && ncoly == 1) {
                return new ValNum(((CorTaskEverything)cvs[0].getResult())._cors[0]);
            }
            Vec[] res = new Vec[ncoly];
            Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(ncoly);
            for (int y = 0; y < ncoly; ++y) {
                res[y] = Vec.makeVec(((CorTaskEverything)cvs[y].getResult())._cors, keys[y]);
            }
            return new ValFrame(new Frame(fry._names, res));
        }
        CorTaskCompleteObsMean taskCompleteObsMean = (CorTaskCompleteObsMean)new CorTaskCompleteObsMean(ncoly, ncolx).doAll(new Frame(fry).add(frx));
        long NACount = taskCompleteObsMean._NACount;
        double[] ymeans = ArrayUtils.div(taskCompleteObsMean._ysum, (double)(fry.numRows() - NACount));
        double[] xmeans = ArrayUtils.div(taskCompleteObsMean._xsum, (double)(fry.numRows() - NACount));
        CorTaskCompleteObs cvs = (CorTaskCompleteObs)new CorTaskCompleteObs(ymeans, xmeans).doAll(new Frame(fry).add(frx));
        if (ncolx == 1 && ncoly == 1) {
            return new ValNum(cvs._cors[0][0] / (double)(fry.numRows() - 1L - NACount));
        }
        Vec[] res = new Vec[ncoly];
        Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(ncoly);
        for (int y = 0; y < ncoly; ++y) {
            res[y] = Vec.makeVec(ArrayUtils.div(cvs._cors[y], (double)(fry.numRows() - 1L - NACount)), keys[y]);
        }
        return new ValFrame(new Frame(fry._names, res));
    }

    private static class CorTaskCompleteObs
    extends MRTask<CorTaskCompleteObs> {
        double[][] _cors;
        final double[] _xmeans;
        final double[] _ymeans;

        CorTaskCompleteObs(double[] ymeans, double[] xmeans) {
            this._ymeans = ymeans;
            this._xmeans = xmeans;
        }

        @Override
        public void map(Chunk[] cs) {
            int ncolx = this._xmeans.length;
            int ncoly = this._ymeans.length;
            double[] xvals = new double[ncolx];
            double[] yvals = new double[ncoly];
            this._cors = new double[ncoly][ncolx];
            int len = cs[0]._len;
            for (int row = 0; row < len; ++row) {
                double yval;
                int y;
                boolean add = true;
                Arrays.fill(xvals, 0.0);
                Arrays.fill(yvals, 0.0);
                for (y = 0; y < ncoly; ++y) {
                    Chunk cy = cs[y];
                    yval = cy.atd(row);
                    if (Double.isNaN(yval)) {
                        add = false;
                        break;
                    }
                    yvals[y] = yval;
                }
                if (add) {
                    for (int x = 0; x < ncolx; ++x) {
                        Chunk cx = cs[x + ncoly];
                        double xval = cx.atd(row);
                        if (Double.isNaN(xval)) {
                            add = false;
                            break;
                        }
                        xvals[x] = xval;
                    }
                }
                if (!add) continue;
                for (y = 0; y < ncoly; ++y) {
                    double[] _cors_y = this._cors[y];
                    yval = yvals[y];
                    double ymean = this._ymeans[y];
                    for (int x = 0; x < ncolx; ++x) {
                        int n = x;
                        _cors_y[n] = _cors_y[n] + (xvals[x] - this._xmeans[x]) * (yval - ymean) / (Math.sqrt(Math.pow(xvals[x] - this._xmeans[x], 2.0)) * Math.sqrt(Math.pow(yval - ymean, 2.0)));
                    }
                }
            }
        }

        @Override
        public void reduce(CorTaskCompleteObs cvt) {
            ArrayUtils.add(this._cors, cvt._cors);
        }
    }

    private static class CorTaskCompleteObsMean
    extends MRTask<CorTaskCompleteObsMean> {
        double[] _xsum;
        double[] _ysum;
        long _NACount;
        int _ncolx;
        int _ncoly;

        CorTaskCompleteObsMean(int ncoly, int ncolx) {
            this._ncolx = ncolx;
            this._ncoly = ncoly;
        }

        @Override
        public void map(Chunk[] cs) {
            this._xsum = new double[this._ncolx];
            this._ysum = new double[this._ncoly];
            double[] xvals = new double[this._ncolx];
            double[] yvals = new double[this._ncoly];
            int len = cs[0]._len;
            for (int row = 0; row < len; ++row) {
                boolean add = true;
                Arrays.fill(xvals, 0.0);
                Arrays.fill(yvals, 0.0);
                for (int y = 0; y < this._ncoly; ++y) {
                    Chunk cy = cs[y];
                    double yval = cy.atd(row);
                    if (Double.isNaN(yval)) {
                        ++this._NACount;
                        add = false;
                        break;
                    }
                    yvals[y] = yval;
                }
                if (add) {
                    for (int x = 0; x < this._ncolx; ++x) {
                        Chunk cx = cs[x + this._ncoly];
                        double xval = cx.atd(row);
                        if (Double.isNaN(xval)) {
                            ++this._NACount;
                            add = false;
                            break;
                        }
                        xvals[x] = xval;
                    }
                }
                if (!add) continue;
                ArrayUtils.add(this._xsum, xvals);
                ArrayUtils.add(this._ysum, yvals);
            }
        }

        @Override
        public void reduce(CorTaskCompleteObsMean cvt) {
            ArrayUtils.add(this._xsum, cvt._xsum);
            ArrayUtils.add(this._ysum, cvt._ysum);
            this._NACount += cvt._NACount;
        }
    }

    private static class CorTaskEverything
    extends MRTask<CorTaskEverything> {
        double[] _cors;
        final double[] _xmeans;
        final double _ymean;

        CorTaskEverything(double ymean, double[] xmeans) {
            this._ymean = ymean;
            this._xmeans = xmeans;
        }

        @Override
        public void map(Chunk[] cs) {
            int ncolsx = cs.length - 1;
            Chunk cy = cs[0];
            int len = cy._len;
            this._cors = new double[ncolsx];
            for (int x = 0; x < ncolsx; ++x) {
                double sum = 0.0;
                double varx = 0.0;
                double vary = 0.0;
                Chunk cx = cs[x + 1];
                double xmean = this._xmeans[x];
                for (int row = 0; row < len; ++row) {
                    varx += (cx.atd(row) - xmean) * (cx.atd(row) - xmean) / (double)(len - 1);
                    vary += (cy.atd(row) - this._ymean) * (cy.atd(row) - this._ymean) / (double)(len - 1);
                    sum += (cx.atd(row) - xmean) * (cy.atd(row) - this._ymean) / (double)(len - 1);
                }
                this._cors[x] = sum / (Math.sqrt(varx) * Math.sqrt(vary));
            }
        }

        @Override
        public void reduce(CorTaskEverything cvt) {
            ArrayUtils.add(this._cors, cvt._cors);
        }
    }

    private static enum Mode {
        Everything,
        AllObs,
        CompleteObs;

    }
}

