/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.H2O;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.rapids.ValNum;
import water.rapids.ValStr;

class ASTFlatten
extends ASTPrim {
    ASTFlatten() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "flatten";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (fr.numCols() != 1 || fr.numRows() != 1L) {
            return new ValFrame(fr);
        }
        Vec vec = fr.anyVec();
        switch (vec.get_type()) {
            case 0: 
            case 3: {
                return new ValNum(vec.at(0L));
            }
            case 5: {
                return new ValNum(vec.at8(0L));
            }
            case 2: {
                return new ValStr(vec.atStr(new BufferedString(), 0L).toString());
            }
            case 4: {
                return new ValStr(vec.factor(vec.at8(0L)));
            }
        }
        throw H2O.unimpl("The type of vector: " + vec.get_type_str() + " is not supported by " + this.str());
    }
}

