/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import java.util.Arrays;
import water.H2O;
import water.rapids.ASTParameter;
import water.rapids.Env;
import water.rapids.Rapids;
import water.rapids.Val;
import water.util.ArrayUtils;
import water.util.SB;

public class ASTNumList
extends ASTParameter {
    final double[] _bases;
    final double[] _strides;
    final long[] _cnts;
    final boolean _isList;
    boolean _isSort;

    ASTNumList(Rapids e) {
        char c;
        ArrayList<Double> bases = new ArrayList<Double>();
        ArrayList<Double> strides = new ArrayList<Double>();
        ArrayList<Long> cnts = new ArrayList<Long>();
        while ((c = e.skipWS()) != ']') {
            if (c == '#') {
                ++e._x;
            }
            double base = e.number();
            double cnt = 1.0;
            double stride = 1.0;
            c = e.skipWS();
            if (c == ':') {
                e.xpeek(':');
                e.skipWS();
                cnt = e.number();
                if (cnt < 1.0 || (double)((long)cnt) != cnt) {
                    throw new IllegalArgumentException("Count must be a integer larger than zero, " + cnt);
                }
                c = e.skipWS();
                if (c == ':') {
                    e.xpeek(':');
                    e.skipWS();
                    stride = e.number();
                    if (stride < 0.0) {
                        throw new IllegalArgumentException("Stride must be positive, " + stride);
                    }
                    c = e.skipWS();
                }
            }
            if (cnt == 1.0 && stride != 1.0) {
                throw new IllegalArgumentException("If count is 1, then stride must be one (and ignored)");
            }
            bases.add(base);
            cnts.add((long)cnt);
            strides.add(stride);
            if (c != ',') continue;
            e.xpeek(',');
        }
        e.xpeek(']');
        this._bases = new double[bases.size()];
        this._strides = new double[bases.size()];
        this._cnts = new long[bases.size()];
        boolean isList = true;
        for (int i = 0; i < this._bases.length; ++i) {
            this._bases[i] = (Double)bases.get(i);
            this._cnts[i] = (Long)cnts.get(i);
            this._strides[i] = (Double)strides.get(i);
            if (this._cnts[i] == 1L) continue;
            isList = false;
        }
        this._isList = isList;
        boolean isSort = true;
        for (int i = 1; i < this._bases.length; ++i) {
            if (!(this._bases[i - 1] >= this._bases[i])) continue;
            if (this._isList) {
                isSort = false;
                continue;
            }
            throw new IllegalArgumentException("Bases must be monotonically increasing");
        }
        this._isSort = isSort;
    }

    ASTNumList(double d) {
        this._bases = new double[]{d};
        this._strides = new double[]{1.0};
        this._cnts = new long[]{1L};
        this._isSort = true;
        this._isList = true;
    }

    ASTNumList(long lo, long hi_exclusive) {
        this._bases = new double[]{lo};
        this._strides = new double[]{1.0};
        this._cnts = new long[]{hi_exclusive - lo};
        this._isList = false;
        this._isSort = true;
    }

    ASTNumList() {
        this._bases = new double[0];
        this._strides = new double[0];
        this._cnts = new long[0];
        this._isSort = true;
        this._isList = true;
    }

    ASTNumList(double[] list) {
        this._bases = list;
        this._strides = new double[list.length];
        this._cnts = new long[list.length];
        this._isList = true;
        Arrays.fill(this._strides, 1.0);
        Arrays.fill(this._cnts, 1L);
    }

    ASTNumList(int[] list) {
        this(ArrayUtils.copyFromIntArray(list));
    }

    @Override
    public Val exec(Env env) {
        throw new IllegalArgumentException("Number list not allowed here");
    }

    @Override
    public String str() {
        SB sb = new SB().p('[');
        for (int i = 0; i < this._bases.length; ++i) {
            sb.p(this._bases[i]);
            if (this._cnts[i] != 1L) {
                sb.p(':').p(this._bases[i] + (double)this._cnts[i] * this._strides[i]);
                if (this._strides[i] != 1.0 || (double)((long)this._bases[i]) != this._bases[i]) {
                    sb.p(':').p(this._strides[i]);
                }
            }
            if (i >= this._bases.length - 1) continue;
            sb.p(',');
        }
        return sb.p(']').toString();
    }

    @Override
    int nargs() {
        return -1;
    }

    @Override
    public String toJavaString() {
        double[] ary = this.expand();
        if (ary == null || ary.length == 0) {
            return "\"null\"";
        }
        SB sb = new SB().p('{');
        for (int i = 0; i < ary.length - 1; ++i) {
            sb.p(ary[i]).p(',');
        }
        return sb.p('}').toString();
    }

    public double[] expand() {
        int nrows = (int)this.cnt();
        int r = 0;
        double[] vals = new double[nrows];
        for (int i = 0; i < this._bases.length; ++i) {
            for (double d = this._bases[i]; d < this._bases[i] + (double)this._cnts[i] * this._strides[i]; d += this._strides[i]) {
                vals[r++] = d;
            }
        }
        return vals;
    }

    ASTNumList sort() {
        if (this._isSort) {
            return this;
        }
        int[] idxs = ArrayUtils.seq(0, this._bases.length);
        ArrayUtils.sort(idxs, this._bases);
        double[] bases = (double[])this._bases.clone();
        double[] strides = (double[])this._strides.clone();
        long[] cnts = (long[])this._cnts.clone();
        for (int i = 0; i < idxs.length; ++i) {
            this._bases[i] = bases[idxs[i]];
            this._strides[i] = strides[idxs[i]];
            this._cnts[i] = cnts[idxs[i]];
        }
        this._isSort = true;
        return this;
    }

    int[] expand4() {
        int nrows = (int)this.cnt();
        int r = 0;
        int[] vals = new int[nrows];
        for (int i = 0; i < this._bases.length; ++i) {
            for (double d = this._bases[i]; d < this._bases[i] + (double)this._cnts[i] * this._strides[i]; d += this._strides[i]) {
                vals[r++] = (int)d;
            }
        }
        return vals;
    }

    int[] expand4Sort() {
        return this.sort().expand4();
    }

    long[] expand8() {
        int nrows = (int)this.cnt();
        int r = 0;
        long[] vals = new long[nrows];
        for (int i = 0; i < this._bases.length; ++i) {
            for (double d = this._bases[i]; d < this._bases[i] + (double)this._cnts[i] * this._strides[i]; d += this._strides[i]) {
                vals[r++] = (long)d;
            }
        }
        return vals;
    }

    long[] expand8Sort() {
        return this.sort().expand8();
    }

    double max() {
        assert (this._isSort);
        return this._bases[this._bases.length - 1] + (double)this._cnts[this._cnts.length - 1] * this._strides[this._strides.length - 1];
    }

    double min() {
        assert (this._isSort);
        return this._bases[0];
    }

    long cnt() {
        return ArrayUtils.sum(this._cnts);
    }

    boolean isDense() {
        return this._cnts.length == 1 && this._bases[0] == 0.0 && this._strides[0] == 1.0;
    }

    boolean isEmpty() {
        return this._bases.length == 0;
    }

    boolean has(long v) {
        assert (this._isSort);
        if (v < 0L) {
            throw H2O.unimpl();
        }
        int idx = Arrays.binarySearch(this._bases, (double)v);
        if (idx >= 0) {
            return true;
        }
        if ((idx = -idx - 2) < 0) {
            return false;
        }
        assert (this._bases[idx] < (double)v);
        return (double)v < this._bases[idx] + (double)this._cnts[idx] * this._strides[idx];
    }

    @Override
    int[] columns(String[] names) {
        int nrows = 0;
        int r = 0;
        for (int i = 0; i < this._bases.length; ++i) {
            nrows = (int)((double)nrows + (Math.min(this._bases[i] + (double)this._cnts[i], (double)(names.length + 1)) - Math.min(this._bases[i], (double)(names.length + 1))));
        }
        int[] vals = new int[nrows];
        for (int i = 0; i < this._bases.length; ++i) {
            int lim = Math.min((int)(this._bases[i] + (double)this._cnts[i]), names.length + 1);
            int d = Math.min((int)this._bases[i], names.length + 1);
            while (d < lim) {
                vals[r++] = d++;
            }
        }
        return vals;
    }
}

