/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.H2O;
import water.Key;
import water.RPC;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.RadixCount;
import water.rapids.SendSplitMSB;
import water.rapids.SingleThreadRadixOrder;
import water.rapids.SplitByMSBLocal;
import water.util.ArrayUtils;
import water.util.Log;

public class RadixOrder
extends H2O.H2OCountedCompleter<RadixOrder> {
    int[] _shift;
    int[] _bytesUsed;
    long[] _base;
    Frame _DF;
    boolean _isLeft;
    int[] _whichCols;
    int[][] _id_maps;

    RadixOrder(Frame DF, boolean isLeft, int[] whichCols, int[][] id_maps) {
        this._DF = DF;
        this._isLeft = isLeft;
        this._whichCols = whichCols;
        this._id_maps = id_maps;
    }

    @Override
    public void compute2() {
        int i;
        long t0 = System.nanoTime();
        this._shift = new int[this._whichCols.length];
        this._bytesUsed = new int[this._whichCols.length];
        this._base = new long[this._whichCols.length];
        for (int i2 = 0; i2 < this._whichCols.length; ++i2) {
            long max;
            Vec col = this._DF.vec(this._whichCols[i2]);
            if (col.isCategorical()) {
                this._base[i2] = 0L;
                if (this._isLeft) {
                    assert (this._id_maps[i2] != null);
                    max = ArrayUtils.maxValue(this._id_maps[i2]);
                } else {
                    max = (long)col.max();
                }
            } else {
                this._base[i2] = (long)col.min();
                max = (long)col.max();
            }
            long range = max - this._base[i2] + 2L;
            int biggestBit = 1 + (int)Math.floor(Math.log(range) / Math.log(2.0));
            if (biggestBit < 8) {
                Log.warn("biggest bit should be >= 8 otherwise need to dip into next column (TODO)");
            }
            assert (biggestBit >= 1);
            this._shift[i2] = Math.max(8, biggestBit) - 8;
            long MSBwidth = 1 << this._shift[i2];
            if (this._base[i2] % MSBwidth != 0L) {
                this._base[i2] = MSBwidth * (this._base[i2] / MSBwidth + (long)(this._base[i2] < 0L ? -1 : 0));
                assert (this._base[i2] % MSBwidth == 0L);
            }
            this._bytesUsed[i2] = (this._shift[i2] + 15) / 8;
            assert ((biggestBit - 1) / 8 + 1 == this._bytesUsed[i2]);
            int chk = (int)(max - this._base[i2] + 1L) >> this._shift[i2];
            assert (chk <= 255);
            assert (chk >= 0);
        }
        int keySize = ArrayUtils.sum(this._bytesUsed);
        int batchSize = 0x10000000 / Math.max(keySize, 8) / 2;
        System.out.println("Time to use rollup stats to determine biggestBit: " + (double)(System.nanoTime() - t0) / 1.0E9);
        t0 = System.nanoTime();
        new RadixCount(this._isLeft, this._base[0], this._shift[0], this._whichCols[0], this._isLeft ? this._id_maps : (int[][])null).doAll(this._DF.vec(this._whichCols[0]));
        System.out.println("Time of MSB count MRTask left local on each node (no reduce): " + (double)(System.nanoTime() - t0) / 1.0E9);
        t0 = System.nanoTime();
        Key linkTwoMRTask = Key.make();
        SplitByMSBLocal tmp = (SplitByMSBLocal)new SplitByMSBLocal(this._isLeft, this._base, this._shift[0], keySize, batchSize, this._bytesUsed, this._whichCols, linkTwoMRTask, this._id_maps).doAll(this._DF.vecs(this._whichCols));
        System.out.println("SplitByMSBLocal MRTask (all local per node, no network) took : " + (double)(System.nanoTime() - t0) / 1.0E9);
        System.out.println(tmp.profString());
        t0 = System.nanoTime();
        new SendSplitMSB(linkTwoMRTask).doAllNodes();
        System.out.println("SendSplitMSB across all nodes took : " + (double)(System.nanoTime() - t0) / 1.0E9);
        RPC[] radixOrders = new RPC[256];
        System.out.print("Sending SingleThreadRadixOrder async RPC calls ... ");
        t0 = System.nanoTime();
        for (i = 0; i < 256; ++i) {
            radixOrders[i] = new RPC<SingleThreadRadixOrder>(SplitByMSBLocal.ownerOfMSB(i), new SingleThreadRadixOrder(this._DF, this._isLeft, batchSize, keySize, i)).call();
        }
        System.out.println("took : " + (double)(System.nanoTime() - t0) / 1.0E9);
        System.out.print("Waiting for RPC SingleThreadRadixOrder to finish ... ");
        t0 = System.nanoTime();
        i = 0;
        for (RPC rpc : radixOrders) {
            rpc.get();
            ++i;
        }
        System.out.println("took " + (double)(System.nanoTime() - t0) / 1.0E9);
        this.tryComplete();
    }
}

