/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import hex.Transformer;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.MathUtils;

public class DCTTransformer
extends Transformer<Frame> {
    public Frame _dataset;
    int[] _dimensions = null;
    final boolean _inverse = false;

    public DCTTransformer(Key<Frame> dest) {
        super(dest, Frame.class.getName(), "DCTTransformer job");
    }

    @Override
    protected Job<Frame> execImpl() {
        if (this._dimensions.length != 3) {
            throw new H2OIllegalArgumentException("Need 3 dimensions (width/height/depth): WxHxD (1D: Wx1x1, 2D: WxHx1, 3D: WxHxD)");
        }
        if (ArrayUtils.minValue(this._dimensions) < 1L) {
            throw new H2OIllegalArgumentException("Dimensions must be >= 1");
        }
        if (this._dataset == null) {
            throw new H2OIllegalArgumentException("Missing dataset");
        }
        if (this._dataset.numCols() < this._dimensions[0] * this._dimensions[1] * this._dimensions[2]) {
            throw new H2OIllegalArgumentException("Product of dimensions WxHxD must be <= #columns (" + this._dataset.numCols() + ")");
        }
        MathUtils.DCT.initCheck(this._dataset, this._dimensions[0], this._dimensions[1], this._dimensions[2]);
        return this._job.start(new H2O.H2OCountedCompleter(){

            @Override
            public void compute2() {
                Frame fft = DCTTransformer.this._dimensions[1] == 1 && DCTTransformer.this._dimensions[2] == 1 ? MathUtils.DCT.transform1D(DCTTransformer.this._dataset, DCTTransformer.this._dimensions[0], false) : (DCTTransformer.this._dimensions[2] == 1 ? MathUtils.DCT.transform2D(DCTTransformer.this._dataset, DCTTransformer.this._dimensions[0], DCTTransformer.this._dimensions[1], false) : MathUtils.DCT.transform3D(DCTTransformer.this._dataset, DCTTransformer.this._dimensions[0], DCTTransformer.this._dimensions[1], DCTTransformer.this._dimensions[2], false));
                Frame dest = new Frame(DCTTransformer.this._job._result, fft.names(), fft.vecs());
                DKV.put(dest);
                this.tryComplete();
            }
        }, 1L);
    }
}

