/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.Arrays;
import java.util.HashMap;
import water.H2O;

public class EnumUtils {
    private static HashMap<Class<? extends Enum>, HashMap<String, Enum>> enumMappings = new HashMap();

    public static String[] getNames(Class<? extends Enum<?>> e) {
        return Arrays.toString(e.getEnumConstants()).replaceAll("^.|.$", "").split(", ");
    }

    public static <T extends Enum<T>> T valueOf(Class<T> clz, String name) {
        Enum value;
        HashMap<String, Enum> map = enumMappings.get(clz);
        if (map == null) {
            map = new HashMap();
            enumMappings.put(clz, map);
            for (Enum item : (Enum[])clz.getEnumConstants()) {
                String origName = item.name();
                String unifName = origName.toUpperCase().replaceAll("[^0-9A-Z]", "");
                if (map.containsKey(origName)) {
                    throw H2O.fail("Unexpected key " + origName + " in enum " + clz);
                }
                if (map.containsKey(unifName)) {
                    throw H2O.fail("Non-unique key " + unifName + " in enum " + clz);
                }
                map.put(origName, item);
                map.put(unifName, item);
            }
        }
        if ((value = map.get(name)) == null && name != null) {
            value = map.get(name.toUpperCase().replaceAll("[^0-9A-Z]", ""));
        }
        if (value == null) {
            throw new IllegalArgumentException("No enum constant " + clz.getCanonicalName() + "." + name);
        }
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        return (T)value;
    }
}

