/*
 * Decompiled with CFR 0.152.
 */
package hex.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import water.AbstractH2OExtension;
import water.persist.PersistHdfs;
import water.util.Log;

public class KerberosExtension
extends AbstractH2OExtension {
    public static String NAME = "KrbStandalone";

    public String getExtensionName() {
        return NAME;
    }

    public void onLocalNodeStarted() {
        Configuration conf = PersistHdfs.CONF;
        if (conf == null) {
            return;
        }
        if (KerberosExtension.isKerberosEnabled(conf)) {
            Log.info((Object[])new Object[]{"Kerberos enabled in Hadoop configuration. Trying to login the (default) user."});
            UserGroupInformation.setConfiguration((Configuration)conf);
            try {
                UserGroupInformation.loginUserFromSubject(null);
            }
            catch (IOException e) {
                Log.err((Object[])new Object[]{"Kerberos initialization FAILED. Kerberos ticket needs to be acquired before starting H2O (run kinit).", e});
            }
        } else {
            Log.debug((Object[])new Object[]{"Kerberos not configured"});
        }
    }

    private static boolean isKerberosEnabled(Configuration conf) {
        return "kerberos".equals(conf.get("hadoop.security.authentication"));
    }
}

