/*
 * Decompiled with CFR 0.152.
 */
package hex.security;

import java.io.IOException;
import java.time.Duration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import water.AbstractH2OExtension;
import water.H2O;
import water.persist.PersistHdfs;
import water.persist.security.HdfsDelegationTokenRefresher;
import water.util.Log;

public class KerberosExtension
extends AbstractH2OExtension {
    public static String NAME = "KrbStandalone";

    public String getExtensionName() {
        return NAME;
    }

    public void onLocalNodeStarted() {
        Configuration conf = PersistHdfs.CONF;
        if (conf == null) {
            return;
        }
        if (KerberosExtension.isKerberosEnabled(conf)) {
            UserGroupInformation ugi;
            UserGroupInformation.setConfiguration((Configuration)conf);
            if (H2O.ARGS.keytab_path != null || H2O.ARGS.principal != null) {
                if (H2O.ARGS.keytab_path == null) {
                    throw new RuntimeException("Option keytab_path needs to be specified when option principal is given.");
                }
                if (H2O.ARGS.principal == null) {
                    throw new RuntimeException("Option principal needs to be specified when option keytab_path is given.");
                }
                Log.debug((Object[])new Object[]{"Kerberos enabled in Hadoop configuration. Trying to login user from keytab."});
                ugi = KerberosExtension.loginUserFromKeytab(H2O.ARGS.principal, H2O.ARGS.keytab_path);
            } else {
                Log.debug((Object[])new Object[]{"Kerberos enabled in Hadoop configuration. Trying to login the (default) user."});
                ugi = this.loginDefaultUser();
            }
            if (ugi != null) {
                Log.info((Object[])new Object[]{"Kerberos subsystem initialized. Using user '" + ugi.getShortUserName() + "'."});
            }
            if (H2O.ARGS.hdfs_token_refresh_interval != null) {
                long refreshIntervalSecs = this.parseRefreshIntervalToSecs(H2O.ARGS.hdfs_token_refresh_interval);
                Log.info((Object[])new Object[]{"HDFS token will be refreshed every " + refreshIntervalSecs + "s (user specified " + H2O.ARGS.hdfs_token_refresh_interval + ")."});
                HdfsDelegationTokenRefresher.startRefresher((Configuration)conf, (String)H2O.ARGS.principal, (String)H2O.ARGS.keytab_path, (long)refreshIntervalSecs);
            }
        } else {
            Log.info((Object[])new Object[]{"Kerberos not configured"});
            if (H2O.ARGS.hdfs_token_refresh_interval != null) {
                Log.warn((Object[])new Object[]{"Option hdfs_token_refresh_interval ignored because Kerberos is not configured."});
            }
            if (H2O.ARGS.keytab_path != null) {
                Log.warn((Object[])new Object[]{"Option keytab_path ignored because Kerberos is not configured."});
            }
            if (H2O.ARGS.principal != null) {
                Log.warn((Object[])new Object[]{"Option principal ignored because Kerberos is not configured."});
            }
        }
    }

    private long parseRefreshIntervalToSecs(String refreshInterval) {
        try {
            if (!refreshInterval.contains("P")) {
                refreshInterval = "PT" + refreshInterval;
            }
            return Duration.parse(refreshInterval.toLowerCase()).getSeconds();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse refresh interval, got " + refreshInterval + ". Example of correct specification '4H' (token will be refreshed every 4 hours).", e);
        }
    }

    private UserGroupInformation loginDefaultUser() {
        try {
            UserGroupInformation.loginUserFromSubject(null);
            return UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            Log.err((Object[])new Object[]{"Kerberos initialization FAILED. Kerberos ticket needs to be acquired before starting H2O (run kinit).", e});
            return null;
        }
    }

    private static UserGroupInformation loginUserFromKeytab(String authPrincipal, String authKeytabPath) {
        try {
            return UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)authPrincipal, (String)authKeytabPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to login user " + authPrincipal + " from keytab " + authKeytabPath);
        }
    }

    private static boolean isKerberosEnabled(Configuration conf) {
        return "kerberos".equals(conf.get("hadoop.security.authentication"));
    }
}

