/*
 * Decompiled with CFR 0.152.
 */
package hex.security;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import water.AbstractH2OExtension;
import water.H2O;
import water.init.StandaloneKerberosComponent;
import water.persist.PersistHdfs;
import water.persist.security.HdfsDelegationTokenRefresher;
import water.util.Log;

public class KerberosExtension
extends AbstractH2OExtension {
    public static String NAME = "KrbStandalone";
    private final H2O.OptArgs _args;

    public KerberosExtension() {
        this(H2O.ARGS);
    }

    KerberosExtension(H2O.OptArgs args) {
        this._args = args;
    }

    public String getExtensionName() {
        return NAME;
    }

    public boolean isEnabled() {
        return this.isStandalone();
    }

    private boolean isStandalone() {
        return !this._args.launchedWithHadoopJar();
    }

    public void onLocalNodeStarted() {
        Configuration conf = PersistHdfs.CONF;
        if (conf == null) {
            return;
        }
        if (KerberosExtension.isKerberosEnabled(conf)) {
            UserGroupInformation ugi;
            UserGroupInformation.setConfiguration((Configuration)conf);
            if (this._args.keytab_path != null || this._args.principal != null) {
                if (this._args.keytab_path == null) {
                    throw new RuntimeException("Option keytab_path needs to be specified when option principal is given.");
                }
                if (this._args.principal == null) {
                    throw new RuntimeException("Option principal needs to be specified when option keytab_path is given.");
                }
                Log.debug((Object[])new Object[]{"Kerberos enabled in Hadoop configuration. Trying to login user from keytab."});
                ugi = KerberosExtension.loginUserFromKeytab(this._args.principal, this._args.keytab_path);
            } else {
                Log.debug((Object[])new Object[]{"Kerberos enabled in Hadoop configuration. Trying to login the (default) user."});
                ugi = this.loginDefaultUser();
            }
            if (ugi != null) {
                Log.info((Object[])new Object[]{"Kerberos subsystem initialized. Using user '" + ugi.getShortUserName() + "'."});
            }
            if (this._args.hdfs_token_refresh_interval != null) {
                long refreshIntervalSecs = this.parseRefreshIntervalToSecs(this._args.hdfs_token_refresh_interval);
                Log.info((Object[])new Object[]{"HDFS token will be refreshed every " + refreshIntervalSecs + "s (user specified " + this._args.hdfs_token_refresh_interval + ")."});
                HdfsDelegationTokenRefresher.startRefresher((Configuration)conf, (String)this._args.principal, (String)this._args.keytab_path, (long)refreshIntervalSecs);
            }
            KerberosExtension.initComponents(conf, this._args);
        } else {
            Log.info((Object[])new Object[]{"Kerberos not configured"});
            if (this._args.hdfs_token_refresh_interval != null) {
                Log.warn((Object[])new Object[]{"Option hdfs_token_refresh_interval ignored because Kerberos is not configured."});
            }
            if (this._args.keytab_path != null) {
                Log.warn((Object[])new Object[]{"Option keytab_path ignored because Kerberos is not configured."});
            }
            if (this._args.principal != null) {
                Log.warn((Object[])new Object[]{"Option principal ignored because Kerberos is not configured."});
            }
        }
    }

    static void initComponents(Configuration conf, H2O.OptArgs args) {
        List components = StandaloneKerberosComponent.loadAll();
        List componentNames = components.stream().map(StandaloneKerberosComponent::name).collect(Collectors.toList());
        Log.info((Object[])new Object[]{"Standalone Kerberos components: " + componentNames});
        for (StandaloneKerberosComponent component : components) {
            boolean active = component.initComponent((Object)conf, args);
            String statusMsg = active ? "successfully initialized" : "not active";
            Log.info((Object[])new Object[]{"Component " + component.name() + " " + statusMsg + "."});
        }
    }

    private long parseRefreshIntervalToSecs(String refreshInterval) {
        try {
            if (!refreshInterval.contains("P")) {
                refreshInterval = "PT" + refreshInterval;
            }
            return Duration.parse(refreshInterval.toLowerCase()).getSeconds();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse refresh interval, got " + refreshInterval + ". Example of correct specification '4H' (token will be refreshed every 4 hours).", e);
        }
    }

    private UserGroupInformation loginDefaultUser() {
        try {
            UserGroupInformation.loginUserFromSubject(null);
            return UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            Log.err((Object[])new Object[]{"Kerberos initialization FAILED. Kerberos ticket needs to be acquired before starting H2O (run kinit).", e});
            return null;
        }
    }

    private static UserGroupInformation loginUserFromKeytab(String authPrincipal, String authKeytabPath) {
        try {
            UserGroupInformation.loginUserFromKeytab((String)authPrincipal, (String)authKeytabPath);
            return UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to login user " + authPrincipal + " from keytab " + authKeytabPath);
        }
    }

    private static boolean isKerberosEnabled(Configuration conf) {
        return "kerberos".equals(conf.get("hadoop.security.authentication"));
    }
}

