/*
 * Decompiled with CFR 0.152.
 */
package hex.mojopipeline;

import hex.genmodel.mojopipeline.transformers.MathBinaryTransform;
import hex.genmodel.mojopipeline.transformers.MathUnaryTransform;
import hex.genmodel.mojopipeline.transformers.StringGrepTransform;
import hex.genmodel.mojopipeline.transformers.StringPropertiesBinaryTransform;
import hex.genmodel.mojopipeline.transformers.StringPropertiesUnaryTransform;
import hex.genmodel.mojopipeline.transformers.StringSplitTransform;
import hex.genmodel.mojopipeline.transformers.StringUnaryTransform;
import hex.genmodel.mojopipeline.transformers.TimeUnaryTransform;
import hex.genmodel.mojopipeline.transformers.ToNumericConversion;
import hex.genmodel.mojopipeline.transformers.ToStringConversion;
import hex.mojopipeline.InplaceOperationSimulator;
import hex.mojopipeline.MojoPipeline;
import hex.mojopipeline.ProtobufPipelineWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import mojo.spec.ColumnOuterClass;
import mojo.spec.Custom;
import mojo.spec.PipelineOuterClass;
import water.api.StreamWriteOption;
import water.fvec.ByteVec;
import water.fvec.NFSFileVec;
import water.parser.ParseTime;
import water.rapids.Assembly;
import water.rapids.ast.AstParameter;
import water.rapids.ast.params.AstId;
import water.rapids.ast.params.AstNum;
import water.rapids.ast.params.AstStr;
import water.rapids.ast.params.AstStrList;
import water.rapids.transforms.H2OBinaryOp;
import water.rapids.transforms.H2OColOp;
import water.rapids.transforms.H2OColSelect;
import water.rapids.transforms.Transform;

public class H2OAssemblyToMojoPipelineConverter {
    public static PipelineOuterClass.Pipeline convertToProtoBufPipeline(Assembly assembly) {
        Transform[] stages = assembly.steps();
        Transform firstStage = stages[0];
        Transform lastStage = stages[stages.length - 1];
        PipelineOuterClass.Pipeline.Builder pipelineBuilder = PipelineOuterClass.Pipeline.newBuilder();
        ColumnOuterClass.Column[] inputColumns = H2OAssemblyToMojoPipelineConverter.convertColumns(firstStage.getInputNames(), firstStage.getInputTypes());
        pipelineBuilder.setFeatures(H2OAssemblyToMojoPipelineConverter.frame(inputColumns));
        PipelineOuterClass.Frame.Builder interimsFrameBuilder = PipelineOuterClass.Frame.newBuilder();
        InplaceOperationSimulator inplaceOperationSimulator = new InplaceOperationSimulator();
        for (Transform stage : stages) {
            PipelineOuterClass.Transformation transformation = H2OAssemblyToMojoPipelineConverter.convertStage(stage, inplaceOperationSimulator);
            pipelineBuilder.addTransformations(transformation);
            if (stage.isInPlace() || stage.getNewNames().length <= 0) continue;
            ColumnOuterClass.Column[] tempColumns = H2OAssemblyToMojoPipelineConverter.convertColumns(stage.getNewNames(), stage.getNewTypes());
            interimsFrameBuilder.addAllColumns(Arrays.asList(tempColumns));
        }
        ColumnOuterClass.Column[] replacementColumns = H2OAssemblyToMojoPipelineConverter.convertColumns(inplaceOperationSimulator.getReplacementColumnNames(), inplaceOperationSimulator.getReplacementColumnTypes());
        interimsFrameBuilder.addAllColumns(Arrays.asList(replacementColumns));
        pipelineBuilder.setInterims(interimsFrameBuilder);
        H2OAssemblyToMojoPipelineConverter.setOutputColumns(pipelineBuilder, lastStage, inplaceOperationSimulator);
        PipelineOuterClass.Pipeline pipeline = pipelineBuilder.build();
        return pipeline;
    }

    public static MojoPipeline convert(Assembly assembly) throws IOException {
        PipelineOuterClass.Pipeline pipeline = H2OAssemblyToMojoPipelineConverter.convertToProtoBufPipeline(assembly);
        File tempFile = File.createTempFile("Pipeline", ".mojo");
        tempFile.deleteOnExit();
        ProtobufPipelineWriter writer = new ProtobufPipelineWriter(pipeline);
        try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
            writer.writeTo(outputStream, new StreamWriteOption[0]);
        }
        NFSFileVec mojoData = NFSFileVec.make((File)tempFile);
        return new MojoPipeline((ByteVec)mojoData);
    }

    private static ColumnOuterClass.Column convertColumn(String name, String type) {
        ColumnOuterClass.Column.Builder builder = ColumnOuterClass.Column.newBuilder();
        builder = builder.setName(name);
        if (type.equals("Numeric")) {
            builder.setFloat64Type(ColumnOuterClass.Float64Type.newBuilder().build());
        } else {
            builder.setStrType(ColumnOuterClass.StrType.newBuilder().build());
        }
        return builder.build();
    }

    private static ColumnOuterClass.Column[] convertColumns(String[] names, String[] types) {
        if (names.length != types.length) {
            throw new IllegalArgumentException(String.format("The length of names and types must be the same, but length of names is %d and length of types is %d.", names.length, types.length));
        }
        ColumnOuterClass.Column[] result = new ColumnOuterClass.Column[names.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = H2OAssemblyToMojoPipelineConverter.convertColumn(names[i], types[i]);
        }
        return result;
    }

    private static PipelineOuterClass.Transformation convertStage(Transform stage, InplaceOperationSimulator inplaceOperationSimulator) {
        if (stage instanceof H2OColSelect) {
            return H2OAssemblyToMojoPipelineConverter.convertColSelect((H2OColSelect)stage, inplaceOperationSimulator);
        }
        if (stage instanceof H2OBinaryOp) {
            return H2OAssemblyToMojoPipelineConverter.convertBinaryOp((H2OBinaryOp)stage, inplaceOperationSimulator);
        }
        if (stage instanceof H2OColOp) {
            return H2OAssemblyToMojoPipelineConverter.convertColOp((H2OColOp)stage, inplaceOperationSimulator);
        }
        throw new UnsupportedOperationException(String.format("Stage conversion of type %s is not supported yet.", stage.getClass().getName()));
    }

    private static PipelineOuterClass.Transformation convertColSelect(H2OColSelect stage, InplaceOperationSimulator inplaceOperationSimulator) {
        PipelineOuterClass.Transformation.Builder builder = PipelineOuterClass.Transformation.newBuilder();
        builder.setIdentityOp(PipelineOuterClass.IdentityOp.newBuilder());
        for (String outputColumn : stage.getOutputNames()) {
            String updatedColumn = inplaceOperationSimulator.updateColumn(outputColumn);
            builder.addInputs(updatedColumn);
            builder.addOutputs(updatedColumn);
        }
        return builder.build();
    }

    private static void setOutputColumns(PipelineOuterClass.Pipeline.Builder pipelineBuilder, Transform lastStage, InplaceOperationSimulator inplaceOperationSimulator) {
        PipelineOuterClass.Transformation.Builder builder = PipelineOuterClass.Transformation.newBuilder();
        builder.setIdentityOp(PipelineOuterClass.IdentityOp.newBuilder());
        for (String outputColumn : lastStage.getOutputNames()) {
            String inputColumn = inplaceOperationSimulator.updateColumn(outputColumn);
            builder.addInputs(inputColumn);
            builder.addOutputs("assembly_" + outputColumn);
        }
        PipelineOuterClass.Transformation extraIdentity = builder.build();
        pipelineBuilder.addTransformations(extraIdentity);
        ColumnOuterClass.Column[] outputColumns = H2OAssemblyToMojoPipelineConverter.convertColumns((String[])extraIdentity.getOutputsList().toArray((Object[])new String[0]), lastStage.getOutputTypes());
        pipelineBuilder.setOutputs(H2OAssemblyToMojoPipelineConverter.frame(outputColumns));
    }

    private static PipelineOuterClass.Transformation convertColOp(H2OColOp stage, InplaceOperationSimulator inplaceOperationSimulator) {
        PipelineOuterClass.Transformation.Builder builder = PipelineOuterClass.Transformation.newBuilder();
        String functionName = stage.getAst()._asts[0].str();
        Custom.CustomParam functionParam = Custom.CustomParam.newBuilder().setName("function").setStringParam(functionName).build();
        Custom.CustomParam timezoneParam = Custom.CustomParam.newBuilder().setName("timezone").setStringParam(ParseTime.getTimezone().getID()).build();
        Custom.CustomOp.Builder customOpBuilder = Custom.CustomOp.newBuilder();
        customOpBuilder.addParams(functionParam);
        customOpBuilder.addParams(timezoneParam);
        H2OAssemblyToMojoPipelineConverter.convertParameters(stage, customOpBuilder);
        if (MathUnaryTransform.Factory.functionExists((String)functionName)) {
            customOpBuilder.setTransformerName("hex.genmodel.mojopipeline.transformers.MathUnaryTransform");
        } else if (StringUnaryTransform.Factory.functionExists((String)functionName)) {
            customOpBuilder.setTransformerName("hex.genmodel.mojopipeline.transformers.StringUnaryFunction");
        } else if (StringPropertiesUnaryTransform.Factory.functionExists((String)functionName)) {
            customOpBuilder.setTransformerName("hex.genmodel.mojopipeline.transformers.StringPropertiesUnaryTransform");
        } else if (StringGrepTransform.Factory.functionExists((String)functionName)) {
            customOpBuilder.setTransformerName("hex.genmodel.mojopipeline.transformers.StringGrepTransform");
        } else if (StringSplitTransform.Factory.functionExists((String)functionName)) {
            customOpBuilder.setTransformerName("hex.genmodel.mojopipeline.transformers.StringSplitTransform");
        } else if (TimeUnaryTransform.Factory.functionExists((String)functionName)) {
            customOpBuilder.setTransformerName("hex.genmodel.mojopipeline.transformers.TimeUnaryTransform");
        } else if (ToStringConversion.Factory.functionExists((String)functionName)) {
            customOpBuilder.setTransformerName("hex.genmodel.mojopipeline.transformers.ToStringConversion");
        } else if (ToNumericConversion.Factory.functionExists((String)functionName)) {
            customOpBuilder.setTransformerName("hex.genmodel.mojopipeline.transformers.ToNumericConversion");
        } else {
            throw new UnsupportedOperationException(String.format("The function '%s' in the stage '%s' is not supported.", functionName, stage.name()));
        }
        builder.setCustomOp(customOpBuilder.build());
        for (String inputColumn : stage.getOldNames()) {
            String updatedColumn = inplaceOperationSimulator.updateColumn(inputColumn);
            builder.addInputs(updatedColumn);
        }
        if (stage.isInPlace()) {
            String[] oldNames = stage.getOldNames();
            for (int i = 0; i < oldNames.length; ++i) {
                String oldName = oldNames[i];
                String newName = "temp_" + oldName + "_" + stage.name();
                inplaceOperationSimulator.setNewReplacement(oldName, newName, stage.getNewTypes()[i]);
                builder.addOutputs(newName);
            }
        } else {
            for (String outputColumn : stage.getNewNames()) {
                builder.addOutputs(outputColumn);
            }
        }
        return builder.build();
    }

    private static void convertParameters(H2OColOp stage, Custom.CustomOp.Builder builder) {
        for (Map.Entry entry : stage.getParams().entrySet()) {
            AstNum parameter;
            String name = (String)entry.getKey();
            AstParameter value = (AstParameter)entry.getValue();
            Custom.CustomParam.Builder paramBuilder = Custom.CustomParam.newBuilder().setName(name);
            if (value instanceof AstNum) {
                parameter = (AstNum)value;
                paramBuilder.setFloat64Param(parameter.getNum());
            } else if (value instanceof AstStr) {
                parameter = (AstStr)value;
                paramBuilder.setStringParam(parameter.getStr());
            } else if (value instanceof AstStrList) {
                parameter = (AstStrList)value;
                String joined = String.join((CharSequence)"`````", parameter._strs);
                paramBuilder.setStringParam(joined);
            } else if (value instanceof AstId) {
                parameter = (AstId)value;
                paramBuilder.setStringParam(parameter.str());
            }
            builder.addParams(paramBuilder.build());
        }
    }

    private static PipelineOuterClass.Transformation convertBinaryOp(H2OBinaryOp stage, InplaceOperationSimulator inplaceOperationSimulator) {
        PipelineOuterClass.Transformation.Builder builder = PipelineOuterClass.Transformation.newBuilder();
        String functionName = stage.getAst()._asts[0].str();
        Custom.CustomOp.Builder customOpBuilder = Custom.CustomOp.newBuilder();
        customOpBuilder.addParams(Custom.CustomParam.newBuilder().setName("function").setStringParam(functionName).build());
        customOpBuilder.addParams(Custom.CustomParam.newBuilder().setName("isLeftCol").setBoolParam(stage.getIsLeftColumn()).build());
        customOpBuilder.addParams(Custom.CustomParam.newBuilder().setName("isRightCol").setBoolParam(stage.getIsRightColumn()).build());
        if (!stage.getIsLeftColumn()) {
            customOpBuilder.addParams(Custom.CustomParam.newBuilder().setName("constValue").setFloat64Param(stage.getAst()._asts[1].exec(null).getNum()).build());
        }
        if (!stage.getIsRightColumn()) {
            customOpBuilder.addParams(Custom.CustomParam.newBuilder().setName("constValue").setFloat64Param(stage.getAst()._asts[2].exec(null).getNum()).build());
        }
        H2OAssemblyToMojoPipelineConverter.convertParameters((H2OColOp)stage, customOpBuilder);
        if (MathBinaryTransform.Factory.functionExists((String)functionName)) {
            customOpBuilder.setTransformerName("hex.genmodel.mojopipeline.transformers.MathBinaryTransform");
        } else if (StringPropertiesBinaryTransform.Factory.functionExists((String)functionName)) {
            customOpBuilder.setTransformerName("hex.genmodel.mojopipeline.transformers.StringPropertiesBinaryTransform");
        } else {
            throw new UnsupportedOperationException(String.format("The function '%s' in the stage '%s' is not supported.", functionName, stage.name()));
        }
        builder.setCustomOp(customOpBuilder.build());
        for (String inputColumn : stage.getOldNames()) {
            String updatedColumn = inplaceOperationSimulator.updateColumn(inputColumn);
            builder.addInputs(updatedColumn);
        }
        if (stage.isInPlace()) {
            String[] oldNames = stage.getOldNames();
            String oldName = oldNames[0];
            String newName = "temp_" + oldName + "_" + stage.name();
            inplaceOperationSimulator.setNewReplacement(oldName, newName, stage.getNewTypes()[0]);
            builder.addOutputs(newName);
        } else {
            for (String outputColumn : stage.getNewNames()) {
                builder.addOutputs(outputColumn);
            }
        }
        return builder.build();
    }

    private static PipelineOuterClass.Frame frame(ColumnOuterClass.Column[] cols) {
        return PipelineOuterClass.Frame.newBuilder().addAllColumns(Arrays.asList(cols)).build();
    }
}

