/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.BlendingParams;
import ai.h2o.targetencoding.TargetEncoder;
import ai.h2o.targetencoding.TargetEncoderBuilder;
import ai.h2o.targetencoding.TargetEncoderFrameHelper;
import ai.h2o.targetencoding.TargetEncoderMojoWriter;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import java.util.Map;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.fvec.Frame;
import water.udf.CFuncRef;
import water.util.IcedHashMapGeneric;
import water.util.TwoDimTable;

public class TargetEncoderModel
extends Model<TargetEncoderModel, TargetEncoderParameters, TargetEncoderOutput> {
    protected static final String ALGO_NAME = "TargetEncoder";
    private final TargetEncoder _targetEncoder;

    public TargetEncoderModel(Key<TargetEncoderModel> selfKey, TargetEncoderParameters parms, TargetEncoderOutput output, TargetEncoder tec) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
        this._targetEncoder = tec;
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        throw H2O.unimpl((String)"No Model Metrics for TargetEncoder.");
    }

    public Frame transform(Frame data, byte strategy, double noiseLevel, boolean useBlending, BlendingParams blendingParams, long seed) {
        if (blendingParams == null) {
            blendingParams = ((TargetEncoderParameters)this._parms).getBlendingParameters();
        }
        TargetEncoder.DataLeakageHandlingStrategy leakageHandlingStrategy = TargetEncoder.DataLeakageHandlingStrategy.fromVal(strategy);
        return this._targetEncoder.applyTargetEncoding(data, ((TargetEncoderParameters)this._parms)._response_column, (Map<String, Frame>)((TargetEncoderOutput)this._output)._target_encoding_map, leakageHandlingStrategy, ((TargetEncoderParameters)this._parms)._fold_column, useBlending, noiseLevel, false, blendingParams, seed);
    }

    public Frame transform(Frame data, byte strategy, boolean useBlending, BlendingParams blendingParams, long seed) {
        if (blendingParams == null) {
            blendingParams = ((TargetEncoderParameters)this._parms).getBlendingParameters();
        }
        TargetEncoder.DataLeakageHandlingStrategy leakageHandlingStrategy = TargetEncoder.DataLeakageHandlingStrategy.fromVal(strategy);
        return this._targetEncoder.applyTargetEncoding(data, ((TargetEncoderParameters)this._parms)._response_column, (Map<String, Frame>)((TargetEncoderOutput)this._output)._target_encoding_map, leakageHandlingStrategy, ((TargetEncoderParameters)this._parms)._fold_column, useBlending, false, blendingParams, seed);
    }

    protected double[] score0(double[] data, double[] preds) {
        throw new UnsupportedOperationException("TargetEncoderModel doesn't support scoring on raw data. Use transform() or score() instead.");
    }

    public Frame score(Frame fr, String destination_key, Job j, boolean computeMetrics, CFuncRef customMetricFunc) throws IllegalArgumentException {
        BlendingParams blendingParams = ((TargetEncoderParameters)this._parms).getBlendingParameters();
        TargetEncoder.DataLeakageHandlingStrategy leakageHandlingStrategy = ((TargetEncoderParameters)this._parms)._data_leakage_handling != null ? ((TargetEncoderParameters)this._parms)._data_leakage_handling : TargetEncoder.DataLeakageHandlingStrategy.None;
        return this._targetEncoder.applyTargetEncoding(fr, ((TargetEncoderParameters)this._parms)._response_column, (Map<String, Frame>)((TargetEncoderOutput)this._output)._target_encoding_map, leakageHandlingStrategy, ((TargetEncoderParameters)this._parms)._fold_column, ((TargetEncoderParameters)this._parms)._blending, ((TargetEncoderParameters)this._parms)._noise_level, ((TargetEncoderParameters)this._parms)._seed, (Key<Frame>)Key.make((String)destination_key), blendingParams);
    }

    public TargetEncoderMojoWriter getMojo() {
        return new TargetEncoderMojoWriter(this);
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        TargetEncoderFrameHelper.encodingMapCleanUp(((TargetEncoderOutput)this._output)._target_encoding_map);
        return super.remove_impl(fs, cascade);
    }

    public static class TargetEncoderOutput
    extends Model.Output {
        public IcedHashMapGeneric<String, Frame> _target_encoding_map;
        public TargetEncoderParameters _parms;
        public IcedHashMapGeneric<String, Integer> _column_name_to_missing_val_presence;
        public double _prior_mean;

        public TargetEncoderOutput(TargetEncoderBuilder b, IcedHashMapGeneric<String, Frame> teMap, double priorMean) {
            super((ModelBuilder)b);
            this._target_encoding_map = teMap;
            this._parms = (TargetEncoderParameters)b._parms;
            this._model_summary = this.constructSummary();
            this._column_name_to_missing_val_presence = this.createMissingValuesPresenceMap();
            this._prior_mean = priorMean;
        }

        private IcedHashMapGeneric<String, Integer> createMissingValuesPresenceMap() {
            IcedHashMapGeneric presenceOfNAMap = new IcedHashMapGeneric();
            for (Map.Entry entry : this._target_encoding_map.entrySet()) {
                String teColumn = (String)entry.getKey();
                Frame frameWithEncodings = (Frame)entry.getValue();
                presenceOfNAMap.put((Object)teColumn, (Object)(this._parms.train().vec(teColumn).cardinality() < frameWithEncodings.vec(teColumn).cardinality() ? 1 : 0));
            }
            return presenceOfNAMap;
        }

        private TwoDimTable constructSummary() {
            TwoDimTable summary = new TwoDimTable("Target Encoder model summary.", "Summary for target encoder model", new String[this._names.length], new String[]{"Original name", "Encoded column name"}, new String[]{"string", "string"}, null, null);
            for (int i = 0; i < this._names.length; ++i) {
                String originalColName = this._names[i];
                if (originalColName.equals(this.responseName())) continue;
                summary.set(i, 0, (Object)originalColName);
                summary.set(i, 1, (Object)(originalColName + "_te"));
            }
            return summary;
        }

        public ModelCategory getModelCategory() {
            return ModelCategory.TargetEncoder;
        }
    }

    public static class TargetEncoderParameters
    extends Model.Parameters {
        public boolean _blending = false;
        public double _k = TargetEncoder.DEFAULT_BLENDING_PARAMS.getK();
        public double _f = TargetEncoder.DEFAULT_BLENDING_PARAMS.getF();
        public TargetEncoder.DataLeakageHandlingStrategy _data_leakage_handling = TargetEncoder.DataLeakageHandlingStrategy.None;
        public double _noise_level = 0.01;

        public String algoName() {
            return TargetEncoderModel.ALGO_NAME;
        }

        public String fullName() {
            return TargetEncoderModel.ALGO_NAME;
        }

        public String javaName() {
            return TargetEncoderModel.class.getName();
        }

        public long progressUnits() {
            return 1L;
        }

        public BlendingParams getBlendingParameters() {
            return this._k != 0.0 && this._f != 0.0 ? new BlendingParams(this._k, this._f) : TargetEncoder.DEFAULT_BLENDING_PARAMS;
        }
    }
}

