/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.FrameToTETableTask;
import ai.h2o.targetencoding.TEComponents;
import hex.genmodel.algos.targetencoder.EncodingMap;
import hex.genmodel.algos.targetencoder.EncodingMaps;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import water.DKV;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.Scope;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.fvec.task.FilterByValueTask;
import water.fvec.task.IsNotNaTask;
import water.fvec.task.UniqTask;
import water.rapids.ast.prims.advmath.AstKFold;
import water.rapids.ast.prims.mungers.AstGroup;
import water.util.IcedHashMap;

public class TargetEncoderFrameHelper {
    static Frame addCon(Frame fr, String appendedColumnName, long constant) {
        fr.add(appendedColumnName, Vec.makeCon((double)constant, (long)fr.numRows(), (byte)3));
        return fr;
    }

    static Frame filterOutNAsInColumn(Frame fr, int columnIndex) {
        Frame oneColumnFrame = new Frame(new Vec[]{fr.vec(columnIndex)});
        Frame noNaPredicateFrame = ((IsNotNaTask)new IsNotNaTask().doAll(1, (byte)3, oneColumnFrame)).outputFrame();
        return TargetEncoderFrameHelper.selectByPredicate(fr, noNaPredicateFrame);
    }

    static Frame filterNotByValue(Frame fr, int columnIndex, double value) {
        return TargetEncoderFrameHelper.filterByValueBase(fr, columnIndex, value, true);
    }

    static Frame filterByValue(Frame fr, int columnIndex, double value) {
        return TargetEncoderFrameHelper.filterByValueBase(fr, columnIndex, value, false);
    }

    private static Frame filterByValueBase(Frame fr, int columnIndex, double value, boolean isInverted) {
        Frame predicateFrame = ((FilterByValueTask)new FilterByValueTask(value, isInverted).doAll(1, (byte)3, new Frame(new Vec[]{fr.vec(columnIndex)}))).outputFrame();
        return TargetEncoderFrameHelper.selectByPredicate(fr, predicateFrame);
    }

    private static Frame selectByPredicate(Frame fr, Frame predicateFrame) {
        String[] names = (String[])fr.names().clone();
        byte[] types = (byte[])fr.types().clone();
        String[][] domains = (String[][])fr.domains().clone();
        fr.add("predicate", predicateFrame.anyVec());
        Frame filtered = ((Frame.DeepSelect)new Frame.DeepSelect().doAll(types, fr)).outputFrame(Key.make(), names, domains);
        predicateFrame.delete();
        fr.remove("predicate");
        return filtered;
    }

    static Frame uniqueValuesBy(Frame fr, int columnIndex) {
        Vec v;
        Vec vec0 = fr.vec(columnIndex);
        if (vec0.isCategorical()) {
            v = Vec.makeSeq((long)0L, (long)vec0.domain().length, (boolean)true);
            v.setDomain(vec0.domain());
            DKV.put((Keyed)v);
        } else {
            UniqTask t = (UniqTask)new UniqTask().doAll(new Vec[]{vec0});
            int nUniq = t._uniq.size();
            final AstGroup.G[] uniq = t._uniq.keySet().toArray(new AstGroup.G[nUniq]);
            v = Vec.makeZero((long)nUniq, (byte)vec0.get_type());
            new MRTask(){

                public void map(Chunk c) {
                    int start = (int)c.start();
                    for (int i = 0; i < c._len; ++i) {
                        c.set(i, uniq[i + start]._gs[0]);
                    }
                }
            }.doAll(new Vec[]{v});
        }
        return new Frame(new Vec[]{v});
    }

    static Frame renameColumn(Frame fr, int indexOfColumnToRename, String newName) {
        String[] updatedtNames = fr.names();
        updatedtNames[indexOfColumnToRename] = newName;
        fr.setNames(updatedtNames);
        return fr;
    }

    static Frame renameColumn(Frame fr, String oldName, String newName) {
        return TargetEncoderFrameHelper.renameColumn(fr, fr.find(oldName), newName);
    }

    public static Frame addKFoldColumn(Frame frame, String name, int nfolds, long seed) {
        Vec foldVec = frame.anyVec().makeZero();
        frame.add(name, AstKFold.kfoldColumn((Vec)foldVec, (int)nfolds, (long)(seed == -1L ? new Random().nextLong() : seed)));
        return frame;
    }

    static EncodingMaps convertEncodingMapFromFrameToMap(Map<String, Frame> encodingMap) {
        EncodingMaps convertedEncodingMap = new EncodingMaps();
        HashMap<String, FrameToTETableTask> tasks = new HashMap<String, FrameToTETableTask>();
        for (Map.Entry<String, Frame> entry : encodingMap.entrySet()) {
            Frame encodingsForParticularColumn = entry.getValue();
            FrameToTETableTask task = (FrameToTETableTask)new FrameToTETableTask().dfork(encodingsForParticularColumn);
            tasks.put(entry.getKey(), task);
        }
        for (Map.Entry<String, Object> entry : tasks.entrySet()) {
            FrameToTETableTask taskEntryValue = (FrameToTETableTask)((Object)entry.getValue());
            IcedHashMap<String, TEComponents> table = ((FrameToTETableTask)taskEntryValue.getResult())._table;
            TargetEncoderFrameHelper.convertEncodingMapToGenModelFormat(convertedEncodingMap, entry.getKey(), table);
            Scope.track((Frame[])new Frame[]{taskEntryValue._fr});
        }
        return convertedEncodingMap;
    }

    private static void convertEncodingMapToGenModelFormat(EncodingMaps convertedEncodingMap, String teColumn, IcedHashMap<String, TEComponents> encodingMap) {
        HashMap<Integer, int[]> tableGenModelFormat = new HashMap<Integer, int[]>();
        for (Map.Entry entry : encodingMap.entrySet()) {
            TEComponents value = (TEComponents)((Object)entry.getValue());
            tableGenModelFormat.put(Integer.parseInt((String)entry.getKey()), new int[]{value.getNumerator(), value.getDenominator()});
        }
        convertedEncodingMap.put(teColumn, new EncodingMap(tableGenModelFormat));
    }

    public static Frame register(Frame frame) {
        frame._key = Key.make();
        DKV.put((Keyed)frame);
        return frame;
    }

    public static void encodingMapCleanUp(Map<String, Frame> encodingMap) {
        for (Map.Entry<String, Frame> map : encodingMap.entrySet()) {
            map.getValue().delete();
        }
    }
}

