/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.TargetEncoder;
import ai.h2o.targetencoding.TargetEncoderFrameHelper;
import ai.h2o.targetencoding.TargetEncoderModel;
import hex.Model;
import hex.ModelMojoWriter;
import hex.genmodel.algos.targetencoder.EncodingMap;
import hex.genmodel.algos.targetencoder.EncodingMaps;
import java.io.IOException;
import java.util.Map;
import water.fvec.Frame;
import water.util.IcedHashMapGeneric;

public class TargetEncoderMojoWriter
extends ModelMojoWriter {
    public TargetEncoderMojoWriter() {
    }

    public TargetEncoderMojoWriter(Model model) {
        super(model);
    }

    public String mojoVersion() {
        return "1.00";
    }

    protected void writeModelData() throws IOException {
        this.writeTargetEncodingInfo();
        this.writeTargetEncodingMap();
    }

    protected void writeExtraInfo() {
    }

    private void writeTargetEncodingInfo() throws IOException {
        TargetEncoderModel.TargetEncoderOutput output = (TargetEncoderModel.TargetEncoderOutput)((TargetEncoderModel)this.model)._output;
        TargetEncoderModel.TargetEncoderParameters teParams = output._parms;
        this.writekv("with_blending", teParams._blending);
        if (teParams._blending) {
            this.writekv("inflection_point", teParams._k);
            this.writekv("smoothing", teParams._f);
        }
        this.writekv("priorMean", output._prior_mean);
        IcedHashMapGeneric<String, Integer> _teColumnNameToMissingValuesPresence = output._column_name_to_missing_val_presence;
        this.startWritingTextFile("feature_engineering/target_encoding/te_column_name_to_missing_values_presence.ini");
        for (Map.Entry entry : _teColumnNameToMissingValuesPresence.entrySet()) {
            this.writelnkv((String)entry.getKey(), ((Integer)entry.getValue()).toString());
        }
        this.finishWritingTextFile();
    }

    private void writeTargetEncodingMap() throws IOException {
        TargetEncoderModel.TargetEncoderOutput targetEncoderOutput = (TargetEncoderModel.TargetEncoderOutput)((TargetEncoderModel)this.model)._output;
        IcedHashMapGeneric<String, Frame> targetEncodingMapOnFrames = targetEncoderOutput._target_encoding_map;
        this.ifNeededRegroupEncodingMapsByFoldColumn(targetEncoderOutput, (Map<String, Frame>)targetEncodingMapOnFrames);
        EncodingMaps convertedEncodingMap = TargetEncoderFrameHelper.convertEncodingMapFromFrameToMap(targetEncodingMapOnFrames);
        this.startWritingTextFile("feature_engineering/target_encoding/encoding_map.ini");
        for (Map.Entry columnEncodingsMap : convertedEncodingMap.entrySet()) {
            this.writeln("[" + (String)columnEncodingsMap.getKey() + "]");
            EncodingMap encodings = (EncodingMap)columnEncodingsMap.getValue();
            for (Map.Entry catLevelInfo : encodings.entrySet()) {
                int[] numAndDenom = (int[])catLevelInfo.getValue();
                this.writelnkv(((Integer)catLevelInfo.getKey()).toString(), numAndDenom[0] + " " + numAndDenom[1]);
            }
        }
        this.finishWritingTextFile();
    }

    private void ifNeededRegroupEncodingMapsByFoldColumn(TargetEncoderModel.TargetEncoderOutput targetEncoderOutput, Map<String, Frame> targetEncodingMapOnFrames) {
        String teFoldColumnName = targetEncoderOutput._parms._fold_column;
        if (teFoldColumnName != null) {
            try {
                for (Map.Entry<String, Frame> encodingMapEntry : targetEncodingMapOnFrames.entrySet()) {
                    String key = encodingMapEntry.getKey();
                    Frame originalFrameWithFolds = encodingMapEntry.getValue();
                    targetEncodingMapOnFrames.put(key, TargetEncoder.groupingIgnoringFoldColumn(teFoldColumnName, originalFrameWithFolds, key));
                    originalFrameWithFolds.delete();
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to group encoding maps by fold column", ex);
            }
        }
    }
}

