/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.BlendingParams;
import ai.h2o.targetencoding.TargetEncoder;
import ai.h2o.targetencoding.TargetEncoderHelper;
import ai.h2o.targetencoding.TargetEncoderMojoWriter;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.IntStream;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.Keyed;
import water.Scope;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.fvec.task.FillNAWithDoubleValueTask;
import water.logging.Logger;
import water.logging.LoggerFactory;
import water.udf.CFuncRef;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.StringUtils;
import water.util.TwoDimTable;

public class TargetEncoderModel
extends Model<TargetEncoderModel, TargetEncoderParameters, TargetEncoderOutput> {
    public static final String ALGO_NAME = "TargetEncoder";
    public static final int NO_FOLD = -1;
    static final String TMP_COLUMN_POSTFIX = "_tmp";
    static final String ENCODED_COLUMN_POSTFIX = "_te";
    static final BlendingParams DEFAULT_BLENDING_PARAMS = new BlendingParams(10.0, 20.0);
    private static final Logger logger = LoggerFactory.getLogger(TargetEncoderModel.class);

    public TargetEncoderModel(Key<TargetEncoderModel> selfKey, TargetEncoderParameters parms, TargetEncoderOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        throw H2O.unimpl((String)"No Model Metrics for TargetEncoder.");
    }

    public Frame transformTraining(Frame fr) {
        return this.transformTraining(fr, -1);
    }

    public Frame transformTraining(Frame fr, int outOfFold) {
        assert (outOfFold == -1 || ((TargetEncoderParameters)this._parms)._data_leakage_handling == DataLeakageHandlingStrategy.KFold);
        return this.transform(fr, true, outOfFold, ((TargetEncoderParameters)this._parms).getBlendingParameters(), ((TargetEncoderParameters)this._parms)._noise);
    }

    public Frame transform(Frame fr) {
        return this.transform(fr, ((TargetEncoderParameters)this._parms).getBlendingParameters(), ((TargetEncoderParameters)this._parms)._noise);
    }

    public Frame transform(Frame fr, BlendingParams blendingParams, double noiseLevel) {
        return this.transform(fr, false, -1, blendingParams, noiseLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame transform(Frame fr, boolean asTraining, int outOfFold, BlendingParams blendingParams, double noiseLevel) {
        if (!this.canApplyTargetEncoding(fr)) {
            return fr;
        }
        Frame adaptFr = null;
        try {
            adaptFr = this.adaptForEncoding(fr);
            Frame frame = this.applyTargetEncoding(adaptFr, asTraining, outOfFold, blendingParams, noiseLevel, null);
            return frame;
        }
        finally {
            if (adaptFr != null) {
                Frame.deleteTempFrameAndItsNonSharedVecs((Frame)adaptFr, (Frame)fr);
            }
        }
    }

    protected double[] score0(double[] data, double[] preds) {
        throw new UnsupportedOperationException("TargetEncoderModel doesn't support scoring on raw data. Use transform() or score() instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame score(Frame fr, String destination_key, Job j, boolean computeMetrics, CFuncRef customMetricFunc) throws IllegalArgumentException {
        if (!this.canApplyTargetEncoding(fr)) {
            return new Frame(fr);
        }
        Frame adaptFr = null;
        try {
            adaptFr = this.adaptForEncoding(fr);
            Frame frame = this.applyTargetEncoding(adaptFr, false, -1, ((TargetEncoderParameters)this._parms).getBlendingParameters(), ((TargetEncoderParameters)this._parms)._noise, (Key<Frame>)Key.make((String)destination_key));
            return frame;
        }
        finally {
            if (adaptFr != null) {
                Frame.deleteTempFrameAndItsNonSharedVecs((Frame)adaptFr, (Frame)fr);
            }
        }
    }

    private Frame adaptForEncoding(Frame fr) {
        Frame adaptFr = new Frame(fr);
        for (int i = 0; i < ((TargetEncoderOutput)this._output)._names.length; ++i) {
            int toAdaptIdx;
            Vec toAdapt;
            String col = ((TargetEncoderOutput)this._output)._names[i];
            Object[] domain = ((TargetEncoderOutput)this._output)._domains[i];
            if (domain == null || !ArrayUtils.contains((Object[])adaptFr.names(), (Object)col) || Arrays.equals((toAdapt = adaptFr.vec(toAdaptIdx = adaptFr.find(col))).domain(), domain)) continue;
            Vec adapted = toAdapt.adaptTo((String[])domain);
            adaptFr.replace(toAdaptIdx, adapted);
        }
        return adaptFr;
    }

    private boolean canApplyTargetEncoding(Frame fr) {
        String[] frColumns = fr.names();
        Set teColumns = ((TargetEncoderOutput)this._output)._target_encoding_map.keySet();
        boolean canApply = Arrays.stream(frColumns).anyMatch(teColumns::contains);
        if (!canApply) {
            logger.info("Frame " + fr._key + " has no columns to encode with TargetEncoder, skipping it: columns=" + Arrays.toString(fr.names()) + ", target encoder columns=" + ((TargetEncoderOutput)this._output)._target_encoding_map.keySet());
        }
        return canApply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Frame applyTargetEncoding(Frame data, boolean asTraining, int outOfFold, BlendingParams blendingParams, double noise, Key<Frame> resultKey) {
        EncodingStrategy strategy;
        String targetColumn = ((TargetEncoderParameters)this._parms)._response_column;
        String foldColumn = ((TargetEncoderParameters)this._parms)._fold_column;
        DataLeakageHandlingStrategy dataLeakageHandlingStrategy = asTraining ? ((TargetEncoderParameters)this._parms)._data_leakage_handling : DataLeakageHandlingStrategy.None;
        long seed = ((TargetEncoderParameters)this._parms)._seed;
        assert (outOfFold == -1 || dataLeakageHandlingStrategy == DataLeakageHandlingStrategy.KFold);
        switch (dataLeakageHandlingStrategy) {
            case KFold: {
                if (data.find(foldColumn) >= 0) break;
                throw new H2OIllegalArgumentException("KFold strategy requires a fold column `" + ((TargetEncoderParameters)this._parms)._fold_column + "` like the one used during training.");
            }
            case LeaveOneOut: {
                if (data.find(targetColumn) >= 0) break;
                throw new H2OIllegalArgumentException("LeaveOneOut strategy requires a response column `" + ((TargetEncoderParameters)this._parms)._response_column + "` like the one used during training.");
            }
        }
        if (noise < 0.0) {
            noise = this.defaultNoiseLevel(data, data.find(targetColumn));
            logger.warn("No noise level specified, using default noise level: " + noise);
        }
        if (resultKey == null) {
            resultKey = Key.make();
        }
        switch (dataLeakageHandlingStrategy) {
            case KFold: {
                strategy = new KFoldEncodingStrategy(foldColumn, outOfFold, blendingParams, noise, seed);
                break;
            }
            case LeaveOneOut: {
                strategy = new LeaveOneOutEncodingStrategy(targetColumn, blendingParams, noise, seed);
                break;
            }
            default: {
                strategy = new DefaultEncodingStrategy(blendingParams, noise, seed);
            }
        }
        ArrayList<Object> tmps = new ArrayList<Object>();
        Frame workingFrame = null;
        try {
            workingFrame = data.deepCopy(Key.make().toString());
            Key tmpKey = workingFrame._key;
            Map<String, Frame> columnToEncodings = this.sortByColumnIndex((Map<String, Frame>)((TargetEncoderOutput)this._output)._target_encoding_map);
            for (Map.Entry<String, Frame> kv : columnToEncodings.entrySet()) {
                String columnToEncode = kv.getKey();
                Frame encodings = kv.getValue();
                int colIdx = workingFrame.find(columnToEncode);
                if (colIdx < 0) {
                    logger.warn("Column " + columnToEncode + " is missing in frame " + data._key);
                    continue;
                }
                if (dataLeakageHandlingStrategy != DataLeakageHandlingStrategy.KFold && encodings.find(foldColumn) >= 0) {
                    encodings = TargetEncoderHelper.groupEncodingsByCategory(encodings, encodings.find(columnToEncode));
                    tmps.add(encodings);
                }
                TargetEncoderHelper.imputeCategoricalColumn(workingFrame, colIdx, columnToEncode + TargetEncoderHelper.NA_POSTFIX);
                IntStream posTargetClasses = ((TargetEncoderOutput)this._output).nclasses() == 1 ? IntStream.of(-1) : (((TargetEncoderOutput)this._output).nclasses() == 2 ? IntStream.of(1) : IntStream.range(1, ((TargetEncoderOutput)this._output)._nclasses));
                PrimitiveIterator.OfInt it = posTargetClasses.iterator();
                while (it.hasNext()) {
                    int tc = it.next();
                    try {
                        workingFrame = strategy.apply(workingFrame, columnToEncode, encodings, tc);
                    }
                    finally {
                        DKV.remove((Key)tmpKey);
                        tmpKey = workingFrame._key;
                    }
                }
                if (((TargetEncoderParameters)this._parms)._keep_original_categorical_columns) continue;
                tmps.add(workingFrame.remove(colIdx));
            }
            DKV.remove((Key)tmpKey);
            workingFrame._key = resultKey;
            this.reorderColumns(workingFrame);
            DKV.put((Keyed)workingFrame);
            Frame frame = workingFrame;
            return frame;
        }
        catch (Exception e) {
            if (workingFrame != null) {
                workingFrame.delete();
            }
            throw e;
        }
        finally {
            for (Keyed keyed : tmps) {
                keyed.remove();
            }
        }
    }

    private double defaultNoiseLevel(Frame fr, int targetIndex) {
        double defaultNoiseLevel = 0.01;
        double noiseLevel = 0.0;
        if (targetIndex >= 0) {
            Vec targetVec = fr.vec(targetIndex);
            noiseLevel = targetVec.isNumeric() ? defaultNoiseLevel * (targetVec.max() - targetVec.min()) : defaultNoiseLevel;
        }
        return noiseLevel;
    }

    Map<String, Frame> sortByColumnIndex(Map<String, Frame> encodingMap) {
        Map<String, Integer> nameToIdx = TargetEncoderHelper.nameToIndex(((TargetEncoderOutput)this._output)._names);
        TreeMap<String, Frame> sorted = new TreeMap<String, Frame>(Comparator.comparingInt(nameToIdx::get));
        sorted.putAll(encodingMap);
        return sorted;
    }

    private void reorderColumns(Frame fr) {
        Object[] toTheEnd = ((TargetEncoderParameters)this._parms).getNonPredictors();
        Map<String, Integer> nameToIdx = TargetEncoderHelper.nameToIndex(fr);
        ArrayList<Integer> toAppendAfterNumericals = new ArrayList<Integer>();
        String[] columns = fr.names();
        int[] newOrder = new int[columns.length];
        int offset = 0;
        for (int i = 0; i < columns.length; ++i) {
            if (ArrayUtils.contains((Object[])toTheEnd, (Object)columns[i])) continue;
            Vec vec = fr.vec(i);
            if (vec.isCategorical()) {
                toAppendAfterNumericals.add(i);
                continue;
            }
            newOrder[offset++] = i;
        }
        for (Object col : toTheEnd) {
            if (!nameToIdx.containsKey(col)) continue;
            toAppendAfterNumericals.add(nameToIdx.get(col));
        }
        Iterator iterator = toAppendAfterNumericals.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            newOrder[offset++] = idx;
        }
        fr.reOrder(newOrder);
    }

    public TargetEncoderMojoWriter getMojo() {
        return new TargetEncoderMojoWriter(this);
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        if (((TargetEncoderOutput)this._output)._target_encoding_map != null) {
            for (Frame encodings : ((TargetEncoderOutput)this._output)._target_encoding_map.values()) {
                encodings.delete();
            }
        }
        return super.remove_impl(fs, cascade);
    }

    private static class DefaultEncodingStrategy
    extends EncodingStrategy {
        public DefaultEncodingStrategy(BlendingParams blendingParams, double noise, long seed) {
            super(blendingParams, noise, seed);
        }

        @Override
        public Frame doApply(Frame fr, String columnToEncode, Frame encodings, String encodedColumn, int targetClass) {
            int teColumnIdx = fr.find(columnToEncode);
            int encodingsTEColIdx = encodings.find(columnToEncode);
            double priorMean = TargetEncoderHelper.computePriorMean(encodings);
            Frame joinedFrame = TargetEncoderHelper.mergeEncodings(fr, encodings, teColumnIdx, encodingsTEColIdx);
            Scope.track((Frame[])new Frame[]{joinedFrame});
            int encodedColIdx = TargetEncoderHelper.applyEncodings(joinedFrame, encodedColumn, priorMean, this._blendingParams);
            this.applyNoise(joinedFrame, encodedColIdx, this._noise, this._seed);
            double valueForImputation = this.valueForImputation(columnToEncode, encodings, priorMean, this._blendingParams);
            this.imputeMissingValues(joinedFrame, encodedColIdx, valueForImputation);
            this.removeNumeratorAndDenominatorColumns(joinedFrame);
            return joinedFrame;
        }
    }

    private static class LeaveOneOutEncodingStrategy
    extends EncodingStrategy {
        String _targetColumn;

        public LeaveOneOutEncodingStrategy(String targetColumn, BlendingParams blendingParams, double noise, long seed) {
            super(blendingParams, noise, seed);
            this._targetColumn = targetColumn;
        }

        @Override
        public Frame doApply(Frame fr, String columnToEncode, Frame encodings, String encodedColumn, int targetClass) {
            int teColumnIdx = fr.find(columnToEncode);
            int encodingsTEColIdx = encodings.find(columnToEncode);
            double priorMean = TargetEncoderHelper.computePriorMean(encodings);
            Frame joinedFrame = TargetEncoderHelper.mergeEncodings(fr, encodings, teColumnIdx, encodingsTEColIdx);
            Scope.track((Frame[])new Frame[]{joinedFrame});
            TargetEncoderHelper.subtractTargetValueForLOO(joinedFrame, this._targetColumn, targetClass);
            int encodedColIdx = TargetEncoderHelper.applyEncodings(joinedFrame, encodedColumn, priorMean, this._blendingParams);
            this.applyNoise(joinedFrame, encodedColIdx, this._noise, this._seed);
            this.imputeMissingValues(joinedFrame, encodedColIdx, priorMean);
            this.removeNumeratorAndDenominatorColumns(joinedFrame);
            return joinedFrame;
        }
    }

    private static class KFoldEncodingStrategy
    extends EncodingStrategy {
        String _foldColumn;
        int _outOfFold;

        public KFoldEncodingStrategy(String foldColumn, int outOfFold, BlendingParams blendingParams, double noise, long seed) {
            super(blendingParams, noise, seed);
            this._foldColumn = foldColumn;
            this._outOfFold = outOfFold;
        }

        @Override
        public Frame doApply(Frame fr, String columnToEncode, Frame encodings, String encodedColumn, int targetClass) {
            int foldColIdx;
            Frame workingFrame = fr;
            int teColumnIdx = fr.find(columnToEncode);
            if (this._outOfFold == -1) {
                foldColIdx = fr.find(this._foldColumn);
            } else {
                workingFrame = new Frame(fr);
                Vec tmpFoldCol = workingFrame.anyVec().makeCon((double)this._outOfFold);
                Scope.track((Vec)tmpFoldCol);
                workingFrame.add(new String[]{this._foldColumn + TargetEncoderModel.TMP_COLUMN_POSTFIX}, new Vec[]{tmpFoldCol});
                foldColIdx = workingFrame.numCols() - 1;
            }
            int encodingsFoldColIdx = encodings.find(this._foldColumn);
            int encodingsTEColIdx = encodings.find(columnToEncode);
            long[] foldValues = TargetEncoderHelper.getUniqueColumnValues(encodings, encodingsFoldColIdx);
            int maxFoldValue = (int)ArrayUtils.maxValue((long[])foldValues);
            double priorMean = TargetEncoderHelper.computePriorMean(encodings);
            Frame joinedFrame = TargetEncoderHelper.mergeEncodings(workingFrame, encodings, teColumnIdx, foldColIdx, encodingsTEColIdx, encodingsFoldColIdx, maxFoldValue);
            Scope.track((Frame[])new Frame[]{joinedFrame});
            if (this._outOfFold != -1) {
                joinedFrame.remove(foldColIdx);
            }
            int encodedColIdx = TargetEncoderHelper.applyEncodings(joinedFrame, encodedColumn, priorMean, this._blendingParams);
            this.applyNoise(joinedFrame, encodedColIdx, this._noise, this._seed);
            this.imputeMissingValues(joinedFrame, encodedColIdx, priorMean);
            this.removeNumeratorAndDenominatorColumns(joinedFrame);
            return joinedFrame;
        }
    }

    private static abstract class EncodingStrategy {
        BlendingParams _blendingParams;
        double _noise;
        long _seed;

        public EncodingStrategy(BlendingParams blendingParams, double noise, long seed) {
            this._blendingParams = blendingParams;
            this._noise = noise;
            this._seed = seed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Frame apply(Frame fr, String columnToEncode, Frame encodings, int targetClass) {
            try {
                Frame appliedEncodings;
                String encodedColumn;
                Scope.enter();
                int tcIdx = encodings.find(TargetEncoderHelper.TARGETCLASS_COL);
                if (tcIdx < 0) {
                    encodedColumn = columnToEncode + TargetEncoderModel.ENCODED_COLUMN_POSTFIX;
                    appliedEncodings = encodings;
                } else {
                    String targetClassName = encodings.vec(tcIdx).domain()[targetClass];
                    encodedColumn = columnToEncode + "_" + StringUtils.sanitizeIdentifier((String)targetClassName) + TargetEncoderModel.ENCODED_COLUMN_POSTFIX;
                    appliedEncodings = TargetEncoderHelper.filterByValue(encodings, tcIdx, targetClass);
                    Scope.track((Frame[])new Frame[]{appliedEncodings});
                    appliedEncodings.remove(TargetEncoderHelper.TARGETCLASS_COL);
                }
                Frame encoded = this.doApply(fr, columnToEncode, appliedEncodings, encodedColumn, targetClass);
                Scope.untrack((Frame[])new Frame[]{encoded});
                Frame frame = encoded;
                return frame;
            }
            finally {
                Scope.exit((Key[])new Key[0]);
            }
        }

        public abstract Frame doApply(Frame var1, String var2, Frame var3, String var4, int var5);

        protected void applyNoise(Frame frame, int columnIdx, double noiseLevel, long seed) {
            if (noiseLevel > 0.0) {
                TargetEncoderHelper.addNoise(frame, columnIdx, noiseLevel, seed);
            }
        }

        protected void imputeMissingValues(Frame fr, int columnIndex, double imputedValue) {
            Vec vec = fr.vec(columnIndex);
            assert (vec.get_type() == 3) : "Imputation of missing value is supported only for numerical vectors.";
            if (vec.naCnt() > 0L) {
                new FillNAWithDoubleValueTask(columnIndex, imputedValue).doAll(fr);
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("Frame with id = %s was imputed with posterior value = %f ( %d rows were affected)", fr._key, imputedValue, vec.naCnt()));
                }
            }
        }

        protected double valueForImputation(String columnToEncode, Frame encodings, double priorMean, BlendingParams blendingParams) {
            boolean useBlending;
            assert (encodings.name(0).equals(columnToEncode));
            int nRows = (int)encodings.numRows();
            String lastDomain = encodings.domains()[0][nRows - 1];
            boolean hadMissingValues = lastDomain.equals(columnToEncode + TargetEncoderHelper.NA_POSTFIX);
            double numeratorNA = encodings.vec(TargetEncoderHelper.NUMERATOR_COL).at((long)(nRows - 1));
            long denominatorNA = encodings.vec(TargetEncoderHelper.DENOMINATOR_COL).at8((long)(nRows - 1));
            double posteriorNA = numeratorNA / (double)denominatorNA;
            boolean bl = useBlending = blendingParams != null;
            return !hadMissingValues ? priorMean : (useBlending ? TargetEncoderHelper.getBlendedValue(posteriorNA, priorMean, denominatorNA, blendingParams) : posteriorNA);
        }

        protected void removeNumeratorAndDenominatorColumns(Frame fr) {
            Vec removedNumerator = fr.remove(TargetEncoderHelper.NUMERATOR_COL);
            removedNumerator.remove();
            Vec removedDenominator = fr.remove(TargetEncoderHelper.DENOMINATOR_COL);
            removedDenominator.remove();
        }
    }

    public static class TargetEncoderOutput
    extends Model.Output {
        public final TargetEncoderParameters _parms;
        public final int _nclasses;
        public final IcedHashMap<String, Frame> _target_encoding_map;
        public final IcedHashMap<String, Boolean> _te_column_to_hasNAs;

        public TargetEncoderOutput(TargetEncoder b, IcedHashMap<String, Frame> teMap) {
            super((ModelBuilder)b);
            this._parms = (TargetEncoderParameters)b._parms;
            this._nclasses = b.nclasses();
            this._target_encoding_map = teMap;
            this._model_summary = this.constructSummary();
            this._te_column_to_hasNAs = this.buildCol2HasNAsMap();
        }

        private IcedHashMap<String, Boolean> buildCol2HasNAsMap() {
            IcedHashMap col2HasNAs = new IcedHashMap();
            for (Map.Entry entry : this._target_encoding_map.entrySet()) {
                String teColumn = (String)entry.getKey();
                Frame encodingsFrame = (Frame)entry.getValue();
                boolean hasNAs = this._parms.train().vec(teColumn).cardinality() < encodingsFrame.vec(teColumn).cardinality();
                col2HasNAs.put((Object)teColumn, (Object)hasNAs);
            }
            return col2HasNAs;
        }

        private TwoDimTable constructSummary() {
            String[] columnsForSummary = ArrayUtils.difference((String[])this._names, (String[])new String[]{this.responseName(), this.foldName()});
            TwoDimTable summary = new TwoDimTable("Target Encoder model summary.", "Summary for target encoder model", new String[columnsForSummary.length], new String[]{"Original name", "Encoded column name"}, new String[]{"string", "string"}, null, null);
            for (int i = 0; i < columnsForSummary.length; ++i) {
                String originalColName = columnsForSummary[i];
                summary.set(i, 0, (Object)originalColName);
                summary.set(i, 1, (Object)(originalColName + TargetEncoderModel.ENCODED_COLUMN_POSTFIX));
            }
            return summary;
        }

        public ModelCategory getModelCategory() {
            return ModelCategory.TargetEncoder;
        }
    }

    public static class TargetEncoderParameters
    extends Model.Parameters {
        public boolean _blending = false;
        public double _inflection_point = DEFAULT_BLENDING_PARAMS.getInflectionPoint();
        public double _smoothing = DEFAULT_BLENDING_PARAMS.getSmoothing();
        public DataLeakageHandlingStrategy _data_leakage_handling = DataLeakageHandlingStrategy.None;
        public double _noise = 0.01;
        public boolean _keep_original_categorical_columns = true;

        public String algoName() {
            return TargetEncoderModel.ALGO_NAME;
        }

        public String fullName() {
            return TargetEncoderModel.ALGO_NAME;
        }

        public String javaName() {
            return TargetEncoderModel.class.getName();
        }

        public long progressUnits() {
            return 1L;
        }

        public BlendingParams getBlendingParameters() {
            return this._blending ? (this._inflection_point != 0.0 && this._smoothing != 0.0 ? new BlendingParams(this._inflection_point, this._smoothing) : DEFAULT_BLENDING_PARAMS) : null;
        }

        protected boolean defaultDropConsCols() {
            return false;
        }
    }

    public static enum DataLeakageHandlingStrategy {
        LeaveOneOut,
        KFold,
        None;

    }
}

