/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding.interaction;

import water.Iced;
import water.util.ArrayUtils;

class InteractionsEncoder
extends Iced {
    static final String UNSEEN = "_UNSEEN_";
    static final String NA = "_NA_";
    private boolean _encodeUnseenAsNA;
    private String[][] _interactingDomains;
    private long[] _encodingFactors;

    InteractionsEncoder(String[][] interactingDomains, boolean encodeUnseenAsNA) {
        this._encodeUnseenAsNA = encodeUnseenAsNA;
        this._interactingDomains = interactingDomains;
        this._encodingFactors = this.createEncodingFactors();
    }

    long encode(int[] interactingValues) {
        long value = 0L;
        for (int i = 0; i < interactingValues.length; ++i) {
            int domainCard = this._interactingDomains[i].length;
            long interactionFactor = this._encodingFactors[i];
            int ival = interactingValues[i];
            if (ival >= domainCard) {
                ival = domainCard;
            }
            if (ival < 0) {
                ival = this._encodeUnseenAsNA ? domainCard : domainCard + 1;
            }
            value += (long)ival * interactionFactor;
        }
        return value;
    }

    long encodeStr(String[] interactingValues) {
        int[] values = new int[interactingValues.length];
        for (int i = 0; i < interactingValues.length; ++i) {
            Object[] domain = this._interactingDomains[i];
            String val = interactingValues[i];
            int ival = val == null ? -1 : ArrayUtils.find((Object[])domain, (Object)val);
            values[i] = ival < 0 && val != null ? domain.length : ival;
        }
        return this.encode(values);
    }

    int[] decode(long interactionValue) {
        int[] values = new int[this._encodingFactors.length];
        long value = interactionValue;
        for (int i = this._encodingFactors.length - 1; i >= 0; --i) {
            long factor = this._encodingFactors[i];
            values[i] = (int)(value / factor);
            value %= factor;
        }
        return values;
    }

    String[] decodeStr(long interactionValue) {
        int[] values = this.decode(interactionValue);
        String[] catValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            int val = values[i];
            String[] domain = this._interactingDomains[i];
            catValues[i] = val < domain.length ? domain[val] : (i == domain.length ? (this._encodeUnseenAsNA ? null : UNSEEN) : null);
        }
        return catValues;
    }

    private long[] createEncodingFactors() {
        long[] factors = new long[this._interactingDomains.length];
        long multiplier = 1L;
        for (int i = 0; i < this._interactingDomains.length; ++i) {
            int domainCard = this._interactingDomains[i].length;
            int interactionFactor = this._encodeUnseenAsNA ? domainCard + 1 : domainCard + 2;
            factors[i] = multiplier;
            multiplier *= (long)interactionFactor;
        }
        return factors;
    }
}

